/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.taxsettings.model.AccountDetails;
import software.amazon.awssdk.services.taxsettings.model.AccountDetailsListCopier;
import software.amazon.awssdk.services.taxsettings.model.TaxSettingsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTaxRegistrationsResponse
extends TaxSettingsResponse
implements ToCopyableBuilder<Builder, ListTaxRegistrationsResponse> {
    private static final SdkField<List<AccountDetails>> ACCOUNT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountDetails").getter(ListTaxRegistrationsResponse.getter(ListTaxRegistrationsResponse::accountDetails)).setter(ListTaxRegistrationsResponse.setter(Builder::accountDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccountDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTaxRegistrationsResponse.getter(ListTaxRegistrationsResponse::nextToken)).setter(ListTaxRegistrationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_DETAILS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AccountDetails> accountDetails;
    private final String nextToken;

    private ListTaxRegistrationsResponse(BuilderImpl builder) {
        super(builder);
        this.accountDetails = builder.accountDetails;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAccountDetails() {
        return this.accountDetails != null && !(this.accountDetails instanceof SdkAutoConstructList);
    }

    public final List<AccountDetails> accountDetails() {
        return this.accountDetails;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountDetails() ? this.accountDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTaxRegistrationsResponse)) {
            return false;
        }
        ListTaxRegistrationsResponse other = (ListTaxRegistrationsResponse)((Object)obj);
        return this.hasAccountDetails() == other.hasAccountDetails() && Objects.equals(this.accountDetails(), other.accountDetails()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTaxRegistrationsResponse").add("AccountDetails", (Object)(this.accountDetails() == null ? null : "*** Sensitive Data Redacted ***")).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountDetails": {
                return Optional.ofNullable(clazz.cast(this.accountDetails()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTaxRegistrationsResponse, T> g) {
        return obj -> g.apply((ListTaxRegistrationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TaxSettingsResponse.BuilderImpl
    implements Builder {
        private List<AccountDetails> accountDetails = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTaxRegistrationsResponse model) {
            super(model);
            this.accountDetails(model.accountDetails);
            this.nextToken(model.nextToken);
        }

        public final List<AccountDetails.Builder> getAccountDetails() {
            List<AccountDetails.Builder> result = AccountDetailsListCopier.copyToBuilder(this.accountDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountDetails(Collection<AccountDetails.BuilderImpl> accountDetails) {
            this.accountDetails = AccountDetailsListCopier.copyFromBuilder(accountDetails);
        }

        @Override
        public final Builder accountDetails(Collection<AccountDetails> accountDetails) {
            this.accountDetails = AccountDetailsListCopier.copy(accountDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountDetails(AccountDetails ... accountDetails) {
            this.accountDetails(Arrays.asList(accountDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountDetails(Consumer<AccountDetails.Builder> ... accountDetails) {
            this.accountDetails(Stream.of(accountDetails).map(c -> (AccountDetails)((AccountDetails.Builder)AccountDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTaxRegistrationsResponse build() {
            return new ListTaxRegistrationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TaxSettingsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTaxRegistrationsResponse> {
        public Builder accountDetails(Collection<AccountDetails> var1);

        public Builder accountDetails(AccountDetails ... var1);

        public Builder accountDetails(Consumer<AccountDetails.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

