/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.taxsettings.model.Address;
import software.amazon.awssdk.services.taxsettings.model.AddressRoleMapCopier;
import software.amazon.awssdk.services.taxsettings.model.AddressRoleType;
import software.amazon.awssdk.services.taxsettings.model.Jurisdiction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountMetaData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountMetaData> {
    private static final SdkField<String> ACCOUNT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountName").getter(AccountMetaData.getter(AccountMetaData::accountName)).setter(AccountMetaData.setter(Builder::accountName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountName").build()}).build();
    private static final SdkField<Address> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("address").getter(AccountMetaData.getter(AccountMetaData::address)).setter(AccountMetaData.setter(Builder::address)).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("address").build()}).build();
    private static final SdkField<Map<String, Jurisdiction>> ADDRESS_ROLE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("addressRoleMap").getter(AccountMetaData.getter(AccountMetaData::addressRoleMapAsStrings)).setter(AccountMetaData.setter(Builder::addressRoleMapWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addressRoleMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Jurisdiction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("addressType").getter(AccountMetaData.getter(AccountMetaData::addressTypeAsString)).setter(AccountMetaData.setter(Builder::addressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addressType").build()}).build();
    private static final SdkField<String> SELLER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("seller").getter(AccountMetaData.getter(AccountMetaData::seller)).setter(AccountMetaData.setter(Builder::seller)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("seller").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_NAME_FIELD, ADDRESS_FIELD, ADDRESS_ROLE_MAP_FIELD, ADDRESS_TYPE_FIELD, SELLER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountName;
    private final Address address;
    private final Map<String, Jurisdiction> addressRoleMap;
    private final String addressType;
    private final String seller;

    private AccountMetaData(BuilderImpl builder) {
        this.accountName = builder.accountName;
        this.address = builder.address;
        this.addressRoleMap = builder.addressRoleMap;
        this.addressType = builder.addressType;
        this.seller = builder.seller;
    }

    public final String accountName() {
        return this.accountName;
    }

    public final Address address() {
        return this.address;
    }

    public final Map<AddressRoleType, Jurisdiction> addressRoleMap() {
        return AddressRoleMapCopier.copyStringToEnum(this.addressRoleMap);
    }

    public final boolean hasAddressRoleMap() {
        return this.addressRoleMap != null && !(this.addressRoleMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, Jurisdiction> addressRoleMapAsStrings() {
        return this.addressRoleMap;
    }

    public final AddressRoleType addressType() {
        return AddressRoleType.fromValue(this.addressType);
    }

    public final String addressTypeAsString() {
        return this.addressType;
    }

    public final String seller() {
        return this.seller;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountName());
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddressRoleMap() ? this.addressRoleMapAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.addressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.seller());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountMetaData)) {
            return false;
        }
        AccountMetaData other = (AccountMetaData)obj;
        return Objects.equals(this.accountName(), other.accountName()) && Objects.equals(this.address(), other.address()) && this.hasAddressRoleMap() == other.hasAddressRoleMap() && Objects.equals(this.addressRoleMapAsStrings(), other.addressRoleMapAsStrings()) && Objects.equals(this.addressTypeAsString(), other.addressTypeAsString()) && Objects.equals(this.seller(), other.seller());
    }

    public final String toString() {
        return ToString.builder((String)"AccountMetaData").add("AccountName", (Object)this.accountName()).add("Address", (Object)this.address()).add("AddressRoleMap", this.hasAddressRoleMap() ? this.addressRoleMapAsStrings() : null).add("AddressType", (Object)this.addressTypeAsString()).add("Seller", (Object)this.seller()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountName": {
                return Optional.ofNullable(clazz.cast(this.accountName()));
            }
            case "address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "addressRoleMap": {
                return Optional.ofNullable(clazz.cast(this.addressRoleMapAsStrings()));
            }
            case "addressType": {
                return Optional.ofNullable(clazz.cast(this.addressTypeAsString()));
            }
            case "seller": {
                return Optional.ofNullable(clazz.cast(this.seller()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountMetaData, T> g) {
        return obj -> g.apply((AccountMetaData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountName;
        private Address address;
        private Map<String, Jurisdiction> addressRoleMap = DefaultSdkAutoConstructMap.getInstance();
        private String addressType;
        private String seller;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountMetaData model) {
            this.accountName(model.accountName);
            this.address(model.address);
            this.addressRoleMapWithStrings(model.addressRoleMap);
            this.addressType(model.addressType);
            this.seller(model.seller);
        }

        public final String getAccountName() {
            return this.accountName;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public final Address.Builder getAddress() {
            return this.address != null ? this.address.toBuilder() : null;
        }

        public final void setAddress(Address.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(Address address) {
            this.address = address;
            return this;
        }

        public final Map<String, Jurisdiction.Builder> getAddressRoleMap() {
            Map<String, Jurisdiction.Builder> result = AddressRoleMapCopier.copyToBuilder(this.addressRoleMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAddressRoleMap(Map<String, Jurisdiction.BuilderImpl> addressRoleMap) {
            this.addressRoleMap = AddressRoleMapCopier.copyFromBuilder(addressRoleMap);
        }

        @Override
        public final Builder addressRoleMapWithStrings(Map<String, Jurisdiction> addressRoleMap) {
            this.addressRoleMap = AddressRoleMapCopier.copy(addressRoleMap);
            return this;
        }

        @Override
        public final Builder addressRoleMap(Map<AddressRoleType, Jurisdiction> addressRoleMap) {
            this.addressRoleMap = AddressRoleMapCopier.copyEnumToString(addressRoleMap);
            return this;
        }

        public final String getAddressType() {
            return this.addressType;
        }

        public final void setAddressType(String addressType) {
            this.addressType = addressType;
        }

        @Override
        public final Builder addressType(String addressType) {
            this.addressType = addressType;
            return this;
        }

        @Override
        public final Builder addressType(AddressRoleType addressType) {
            this.addressType(addressType == null ? null : addressType.toString());
            return this;
        }

        public final String getSeller() {
            return this.seller;
        }

        public final void setSeller(String seller) {
            this.seller = seller;
        }

        @Override
        public final Builder seller(String seller) {
            this.seller = seller;
            return this;
        }

        public AccountMetaData build() {
            return new AccountMetaData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountMetaData> {
        public Builder accountName(String var1);

        public Builder address(Address var1);

        default public Builder address(Consumer<Address.Builder> address) {
            return this.address((Address)((Address.Builder)Address.builder().applyMutation(address)).build());
        }

        public Builder addressRoleMapWithStrings(Map<String, Jurisdiction> var1);

        public Builder addressRoleMap(Map<AddressRoleType, Jurisdiction> var1);

        public Builder addressType(String var1);

        public Builder addressType(AddressRoleType var1);

        public Builder seller(String var1);
    }
}

