/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.synthetics.SyntheticsClient;
import software.amazon.awssdk.services.synthetics.internal.UserAgentUtils;
import software.amazon.awssdk.services.synthetics.model.DescribeCanariesRequest;
import software.amazon.awssdk.services.synthetics.model.DescribeCanariesResponse;

public class DescribeCanariesIterable
implements SdkIterable<DescribeCanariesResponse> {
    private final SyntheticsClient client;
    private final DescribeCanariesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCanariesIterable(SyntheticsClient client, DescribeCanariesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeCanariesResponseFetcher();
    }

    public Iterator<DescribeCanariesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeCanariesResponseFetcher
    implements SyncPageFetcher<DescribeCanariesResponse> {
        private DescribeCanariesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCanariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeCanariesResponse nextPage(DescribeCanariesResponse previousPage) {
            if (previousPage == null) {
                return DescribeCanariesIterable.this.client.describeCanaries(DescribeCanariesIterable.this.firstRequest);
            }
            return DescribeCanariesIterable.this.client.describeCanaries((DescribeCanariesRequest)((Object)DescribeCanariesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

