/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.synthetics.model.RuntimeVersion;
import software.amazon.awssdk.services.synthetics.model.RuntimeVersionListCopier;
import software.amazon.awssdk.services.synthetics.model.SyntheticsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRuntimeVersionsResponse
extends SyntheticsResponse
implements ToCopyableBuilder<Builder, DescribeRuntimeVersionsResponse> {
    private static final SdkField<List<RuntimeVersion>> RUNTIME_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RuntimeVersions").getter(DescribeRuntimeVersionsResponse.getter(DescribeRuntimeVersionsResponse::runtimeVersions)).setter(DescribeRuntimeVersionsResponse.setter(Builder::runtimeVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuntimeVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeRuntimeVersionsResponse.getter(DescribeRuntimeVersionsResponse::nextToken)).setter(DescribeRuntimeVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUNTIME_VERSIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<RuntimeVersion> runtimeVersions;
    private final String nextToken;

    private DescribeRuntimeVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.runtimeVersions = builder.runtimeVersions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRuntimeVersions() {
        return this.runtimeVersions != null && !(this.runtimeVersions instanceof SdkAutoConstructList);
    }

    public final List<RuntimeVersion> runtimeVersions() {
        return this.runtimeVersions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuntimeVersions() ? this.runtimeVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRuntimeVersionsResponse)) {
            return false;
        }
        DescribeRuntimeVersionsResponse other = (DescribeRuntimeVersionsResponse)((Object)obj);
        return this.hasRuntimeVersions() == other.hasRuntimeVersions() && Objects.equals(this.runtimeVersions(), other.runtimeVersions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRuntimeVersionsResponse").add("RuntimeVersions", this.hasRuntimeVersions() ? this.runtimeVersions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuntimeVersions": {
                return Optional.ofNullable(clazz.cast(this.runtimeVersions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRuntimeVersionsResponse, T> g) {
        return obj -> g.apply((DescribeRuntimeVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SyntheticsResponse.BuilderImpl
    implements Builder {
        private List<RuntimeVersion> runtimeVersions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRuntimeVersionsResponse model) {
            super(model);
            this.runtimeVersions(model.runtimeVersions);
            this.nextToken(model.nextToken);
        }

        public final List<RuntimeVersion.Builder> getRuntimeVersions() {
            List<RuntimeVersion.Builder> result = RuntimeVersionListCopier.copyToBuilder(this.runtimeVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder runtimeVersions(Collection<RuntimeVersion> runtimeVersions) {
            this.runtimeVersions = RuntimeVersionListCopier.copy(runtimeVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runtimeVersions(RuntimeVersion ... runtimeVersions) {
            this.runtimeVersions(Arrays.asList(runtimeVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runtimeVersions(Consumer<RuntimeVersion.Builder> ... runtimeVersions) {
            this.runtimeVersions(Stream.of(runtimeVersions).map(c -> (RuntimeVersion)((RuntimeVersion.Builder)RuntimeVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRuntimeVersions(Collection<RuntimeVersion.BuilderImpl> runtimeVersions) {
            this.runtimeVersions = RuntimeVersionListCopier.copyFromBuilder(runtimeVersions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeRuntimeVersionsResponse build() {
            return new DescribeRuntimeVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SyntheticsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRuntimeVersionsResponse> {
        public Builder runtimeVersions(Collection<RuntimeVersion> var1);

        public Builder runtimeVersions(RuntimeVersion ... var1);

        public Builder runtimeVersions(Consumer<RuntimeVersion.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

