/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.synthetics.model.CanariesLastRunCopier;
import software.amazon.awssdk.services.synthetics.model.CanaryLastRun;
import software.amazon.awssdk.services.synthetics.model.SyntheticsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCanariesLastRunResponse
extends SyntheticsResponse
implements ToCopyableBuilder<Builder, DescribeCanariesLastRunResponse> {
    private static final SdkField<List<CanaryLastRun>> CANARIES_LAST_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeCanariesLastRunResponse.getter(DescribeCanariesLastRunResponse::canariesLastRun)).setter(DescribeCanariesLastRunResponse.setter(Builder::canariesLastRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanariesLastRun").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CanaryLastRun::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeCanariesLastRunResponse.getter(DescribeCanariesLastRunResponse::nextToken)).setter(DescribeCanariesLastRunResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANARIES_LAST_RUN_FIELD, NEXT_TOKEN_FIELD));
    private final List<CanaryLastRun> canariesLastRun;
    private final String nextToken;

    private DescribeCanariesLastRunResponse(BuilderImpl builder) {
        super(builder);
        this.canariesLastRun = builder.canariesLastRun;
        this.nextToken = builder.nextToken;
    }

    public boolean hasCanariesLastRun() {
        return this.canariesLastRun != null && !(this.canariesLastRun instanceof SdkAutoConstructList);
    }

    public List<CanaryLastRun> canariesLastRun() {
        return this.canariesLastRun;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.canariesLastRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCanariesLastRunResponse)) {
            return false;
        }
        DescribeCanariesLastRunResponse other = (DescribeCanariesLastRunResponse)((Object)obj);
        return Objects.equals(this.canariesLastRun(), other.canariesLastRun()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeCanariesLastRunResponse").add("CanariesLastRun", this.canariesLastRun()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CanariesLastRun": {
                return Optional.ofNullable(clazz.cast(this.canariesLastRun()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCanariesLastRunResponse, T> g) {
        return obj -> g.apply((DescribeCanariesLastRunResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SyntheticsResponse.BuilderImpl
    implements Builder {
        private List<CanaryLastRun> canariesLastRun = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCanariesLastRunResponse model) {
            super(model);
            this.canariesLastRun(model.canariesLastRun);
            this.nextToken(model.nextToken);
        }

        public final Collection<CanaryLastRun.Builder> getCanariesLastRun() {
            return this.canariesLastRun != null ? (Collection)this.canariesLastRun.stream().map(CanaryLastRun::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder canariesLastRun(Collection<CanaryLastRun> canariesLastRun) {
            this.canariesLastRun = CanariesLastRunCopier.copy(canariesLastRun);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder canariesLastRun(CanaryLastRun ... canariesLastRun) {
            this.canariesLastRun(Arrays.asList(canariesLastRun));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder canariesLastRun(Consumer<CanaryLastRun.Builder> ... canariesLastRun) {
            this.canariesLastRun(Stream.of(canariesLastRun).map(c -> (CanaryLastRun)((CanaryLastRun.Builder)CanaryLastRun.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCanariesLastRun(Collection<CanaryLastRun.BuilderImpl> canariesLastRun) {
            this.canariesLastRun = CanariesLastRunCopier.copyFromBuilder(canariesLastRun);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeCanariesLastRunResponse build() {
            return new DescribeCanariesLastRunResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SyntheticsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCanariesLastRunResponse> {
        public Builder canariesLastRun(Collection<CanaryLastRun> var1);

        public Builder canariesLastRun(CanaryLastRun ... var1);

        public Builder canariesLastRun(Consumer<CanaryLastRun.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

