/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.ActivityType;
import software.amazon.awssdk.services.swf.model.SwfRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UndeprecateActivityTypeRequest
extends SwfRequest
implements ToCopyableBuilder<Builder, UndeprecateActivityTypeRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domain").getter(UndeprecateActivityTypeRequest.getter(UndeprecateActivityTypeRequest::domain)).setter(UndeprecateActivityTypeRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()}).build();
    private static final SdkField<ActivityType> ACTIVITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("activityType").getter(UndeprecateActivityTypeRequest.getter(UndeprecateActivityTypeRequest::activityType)).setter(UndeprecateActivityTypeRequest.setter(Builder::activityType)).constructor(ActivityType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activityType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, ACTIVITY_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UndeprecateActivityTypeRequest.memberNameToFieldInitializer();
    private final String domain;
    private final ActivityType activityType;

    private UndeprecateActivityTypeRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.activityType = builder.activityType;
    }

    public final String domain() {
        return this.domain;
    }

    public final ActivityType activityType() {
        return this.activityType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.activityType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UndeprecateActivityTypeRequest)) {
            return false;
        }
        UndeprecateActivityTypeRequest other = (UndeprecateActivityTypeRequest)((Object)obj);
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.activityType(), other.activityType());
    }

    public final String toString() {
        return ToString.builder((String)"UndeprecateActivityTypeRequest").add("Domain", (Object)this.domain()).add("ActivityType", (Object)this.activityType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "activityType": {
                return Optional.ofNullable(clazz.cast(this.activityType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("domain", DOMAIN_FIELD);
        map.put("activityType", ACTIVITY_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UndeprecateActivityTypeRequest, T> g) {
        return obj -> g.apply((UndeprecateActivityTypeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SwfRequest.BuilderImpl
    implements Builder {
        private String domain;
        private ActivityType activityType;

        private BuilderImpl() {
        }

        private BuilderImpl(UndeprecateActivityTypeRequest model) {
            super(model);
            this.domain(model.domain);
            this.activityType(model.activityType);
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final ActivityType.Builder getActivityType() {
            return this.activityType != null ? this.activityType.toBuilder() : null;
        }

        public final void setActivityType(ActivityType.BuilderImpl activityType) {
            this.activityType = activityType != null ? activityType.build() : null;
        }

        @Override
        public final Builder activityType(ActivityType activityType) {
            this.activityType = activityType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UndeprecateActivityTypeRequest build() {
            return new UndeprecateActivityTypeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SwfRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UndeprecateActivityTypeRequest> {
        public Builder domain(String var1);

        public Builder activityType(ActivityType var1);

        default public Builder activityType(Consumer<ActivityType.Builder> activityType) {
            return this.activityType((ActivityType)((ActivityType.Builder)ActivityType.builder().applyMutation(activityType)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

