/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a paginated list of information about workflow executions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListClosedWorkflowExecutionsResponse extends SwfResponse implements
        ToCopyableBuilder<ListClosedWorkflowExecutionsResponse.Builder, ListClosedWorkflowExecutionsResponse> {
    private static final SdkField<List<WorkflowExecutionInfo>> EXECUTION_INFOS_FIELD = SdkField
            .<List<WorkflowExecutionInfo>> builder(MarshallingType.LIST)
            .memberName("executionInfos")
            .getter(getter(ListClosedWorkflowExecutionsResponse::executionInfos))
            .setter(setter(Builder::executionInfos))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionInfos").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkflowExecutionInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkflowExecutionInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextPageToken").getter(getter(ListClosedWorkflowExecutionsResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_INFOS_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<WorkflowExecutionInfo> executionInfos;

    private final String nextPageToken;

    private ListClosedWorkflowExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.executionInfos = builder.executionInfos;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExecutionInfos property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExecutionInfos() {
        return executionInfos != null && !(executionInfos instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of workflow information structures.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExecutionInfos} method.
     * </p>
     * 
     * @return The list of workflow information structures.
     */
    public final List<WorkflowExecutionInfo> executionInfos() {
        return executionInfos;
    }

    /**
     * <p>
     * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To retrieve
     * the next page of results, make the call again using the returned token in <code>nextPageToken</code>. Keep all
     * other arguments unchanged.
     * </p>
     * <p>
     * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     * </p>
     * 
     * @return If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
     *         retrieve the next page of results, make the call again using the returned token in
     *         <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
     *         <p>
     *         The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasExecutionInfos() ? executionInfos() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClosedWorkflowExecutionsResponse)) {
            return false;
        }
        ListClosedWorkflowExecutionsResponse other = (ListClosedWorkflowExecutionsResponse) obj;
        return hasExecutionInfos() == other.hasExecutionInfos() && Objects.equals(executionInfos(), other.executionInfos())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListClosedWorkflowExecutionsResponse")
                .add("ExecutionInfos", hasExecutionInfos() ? executionInfos() : null).add("NextPageToken", nextPageToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionInfos":
            return Optional.ofNullable(clazz.cast(executionInfos()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("executionInfos", EXECUTION_INFOS_FIELD);
        map.put("nextPageToken", NEXT_PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListClosedWorkflowExecutionsResponse, T> g) {
        return obj -> g.apply((ListClosedWorkflowExecutionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SwfResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListClosedWorkflowExecutionsResponse> {
        /**
         * <p>
         * The list of workflow information structures.
         * </p>
         * 
         * @param executionInfos
         *        The list of workflow information structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionInfos(Collection<WorkflowExecutionInfo> executionInfos);

        /**
         * <p>
         * The list of workflow information structures.
         * </p>
         * 
         * @param executionInfos
         *        The list of workflow information structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionInfos(WorkflowExecutionInfo... executionInfos);

        /**
         * <p>
         * The list of workflow information structures.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.swf.model.WorkflowExecutionInfo.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.swf.model.WorkflowExecutionInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.swf.model.WorkflowExecutionInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #executionInfos(List<WorkflowExecutionInfo>)}.
         * 
         * @param executionInfos
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.swf.model.WorkflowExecutionInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionInfos(java.util.Collection<WorkflowExecutionInfo>)
         */
        Builder executionInfos(Consumer<WorkflowExecutionInfo.Builder>... executionInfos);

        /**
         * <p>
         * If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         * retrieve the next page of results, make the call again using the returned token in <code>nextPageToken</code>
         * . Keep all other arguments unchanged.
         * </p>
         * <p>
         * The configured <code>maximumPageSize</code> determines how many results can be returned in a single call.
         * </p>
         * 
         * @param nextPageToken
         *        If a <code>NextPageToken</code> was returned by a previous call, there are more results available. To
         *        retrieve the next page of results, make the call again using the returned token in
         *        <code>nextPageToken</code>. Keep all other arguments unchanged.</p>
         *        <p>
         *        The configured <code>maximumPageSize</code> determines how many results can be returned in a single
         *        call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends SwfResponse.BuilderImpl implements Builder {
        private List<WorkflowExecutionInfo> executionInfos = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClosedWorkflowExecutionsResponse model) {
            super(model);
            executionInfos(model.executionInfos);
            nextPageToken(model.nextPageToken);
        }

        public final List<WorkflowExecutionInfo.Builder> getExecutionInfos() {
            List<WorkflowExecutionInfo.Builder> result = WorkflowExecutionInfoListCopier.copyToBuilder(this.executionInfos);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExecutionInfos(Collection<WorkflowExecutionInfo.BuilderImpl> executionInfos) {
            this.executionInfos = WorkflowExecutionInfoListCopier.copyFromBuilder(executionInfos);
        }

        @Override
        public final Builder executionInfos(Collection<WorkflowExecutionInfo> executionInfos) {
            this.executionInfos = WorkflowExecutionInfoListCopier.copy(executionInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionInfos(WorkflowExecutionInfo... executionInfos) {
            executionInfos(Arrays.asList(executionInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionInfos(Consumer<WorkflowExecutionInfo.Builder>... executionInfos) {
            executionInfos(Stream.of(executionInfos).map(c -> WorkflowExecutionInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public ListClosedWorkflowExecutionsResponse build() {
            return new ListClosedWorkflowExecutionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
