/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains general information about a domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainInfo implements SdkPojo, Serializable, ToCopyableBuilder<DomainInfo.Builder, DomainInfo> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DomainInfo::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DomainInfo::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DomainInfo::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(DomainInfo::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD,
            DESCRIPTION_FIELD, ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String status;

    private final String description;

    private final String arn;

    private DomainInfo(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.description = builder.description;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The name of the domain. This name is unique within the account.
     * </p>
     * 
     * @return The name of the domain. This name is unique within the account.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the domain:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REGISTERED</code> – The domain is properly registered and available. You can use this domain for
     * registering types and creating new workflow executions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DEPRECATED</code> – The domain was deprecated using <a>DeprecateDomain</a>, but is still in use. You should
     * not create new workflow executions in this domain.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the domain:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REGISTERED</code> – The domain is properly registered and available. You can use this domain for
     *         registering types and creating new workflow executions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DEPRECATED</code> – The domain was deprecated using <a>DeprecateDomain</a>, but is still in use.
     *         You should not create new workflow executions in this domain.
     *         </p>
     *         </li>
     * @see RegistrationStatus
     */
    public final RegistrationStatus status() {
        return RegistrationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the domain:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REGISTERED</code> – The domain is properly registered and available. You can use this domain for
     * registering types and creating new workflow executions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DEPRECATED</code> – The domain was deprecated using <a>DeprecateDomain</a>, but is still in use. You should
     * not create new workflow executions in this domain.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the domain:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REGISTERED</code> – The domain is properly registered and available. You can use this domain for
     *         registering types and creating new workflow executions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DEPRECATED</code> – The domain was deprecated using <a>DeprecateDomain</a>, but is still in use.
     *         You should not create new workflow executions in this domain.
     *         </p>
     *         </li>
     * @see RegistrationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The description of the domain provided through <a>RegisterDomain</a>.
     * </p>
     * 
     * @return The description of the domain provided through <a>RegisterDomain</a>.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ARN of the domain.
     * </p>
     * 
     * @return The ARN of the domain.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainInfo)) {
            return false;
        }
        DomainInfo other = (DomainInfo) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainInfo").add("Name", name()).add("Status", statusAsString())
                .add("Description", description()).add("Arn", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("arn", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DomainInfo, T> g) {
        return obj -> g.apply((DomainInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainInfo> {
        /**
         * <p>
         * The name of the domain. This name is unique within the account.
         * </p>
         * 
         * @param name
         *        The name of the domain. This name is unique within the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the domain:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REGISTERED</code> – The domain is properly registered and available. You can use this domain for
         * registering types and creating new workflow executions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DEPRECATED</code> – The domain was deprecated using <a>DeprecateDomain</a>, but is still in use. You
         * should not create new workflow executions in this domain.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the domain:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REGISTERED</code> – The domain is properly registered and available. You can use this domain for
         *        registering types and creating new workflow executions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DEPRECATED</code> – The domain was deprecated using <a>DeprecateDomain</a>, but is still in use.
         *        You should not create new workflow executions in this domain.
         *        </p>
         *        </li>
         * @see RegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the domain:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REGISTERED</code> – The domain is properly registered and available. You can use this domain for
         * registering types and creating new workflow executions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DEPRECATED</code> – The domain was deprecated using <a>DeprecateDomain</a>, but is still in use. You
         * should not create new workflow executions in this domain.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the domain:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REGISTERED</code> – The domain is properly registered and available. You can use this domain for
         *        registering types and creating new workflow executions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DEPRECATED</code> – The domain was deprecated using <a>DeprecateDomain</a>, but is still in use.
         *        You should not create new workflow executions in this domain.
         *        </p>
         *        </li>
         * @see RegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationStatus
         */
        Builder status(RegistrationStatus status);

        /**
         * <p>
         * The description of the domain provided through <a>RegisterDomain</a>.
         * </p>
         * 
         * @param description
         *        The description of the domain provided through <a>RegisterDomain</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ARN of the domain.
         * </p>
         * 
         * @param arn
         *        The ARN of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String status;

        private String description;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainInfo model) {
            name(model.name);
            status(model.status);
            description(model.description);
            arn(model.arn);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RegistrationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public DomainInfo build() {
            return new DomainInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
