/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.RegistrationStatus;
import software.amazon.awssdk.services.swf.model.SwfRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDomainsRequest
extends SwfRequest
implements ToCopyableBuilder<Builder, ListDomainsRequest> {
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextPageToken").getter(ListDomainsRequest.getter(ListDomainsRequest::nextPageToken)).setter(ListDomainsRequest.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final SdkField<String> REGISTRATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registrationStatus").getter(ListDomainsRequest.getter(ListDomainsRequest::registrationStatusAsString)).setter(ListDomainsRequest.setter(Builder::registrationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationStatus").build()}).build();
    private static final SdkField<Integer> MAXIMUM_PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maximumPageSize").getter(ListDomainsRequest.getter(ListDomainsRequest::maximumPageSize)).setter(ListDomainsRequest.setter(Builder::maximumPageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumPageSize").build()}).build();
    private static final SdkField<Boolean> REVERSE_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("reverseOrder").getter(ListDomainsRequest.getter(ListDomainsRequest::reverseOrder)).setter(ListDomainsRequest.setter(Builder::reverseOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reverseOrder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_PAGE_TOKEN_FIELD, REGISTRATION_STATUS_FIELD, MAXIMUM_PAGE_SIZE_FIELD, REVERSE_ORDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextPageToken", NEXT_PAGE_TOKEN_FIELD);
            this.put("registrationStatus", REGISTRATION_STATUS_FIELD);
            this.put("maximumPageSize", MAXIMUM_PAGE_SIZE_FIELD);
            this.put("reverseOrder", REVERSE_ORDER_FIELD);
        }
    });
    private final String nextPageToken;
    private final String registrationStatus;
    private final Integer maximumPageSize;
    private final Boolean reverseOrder;

    private ListDomainsRequest(BuilderImpl builder) {
        super(builder);
        this.nextPageToken = builder.nextPageToken;
        this.registrationStatus = builder.registrationStatus;
        this.maximumPageSize = builder.maximumPageSize;
        this.reverseOrder = builder.reverseOrder;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public final RegistrationStatus registrationStatus() {
        return RegistrationStatus.fromValue(this.registrationStatus);
    }

    public final String registrationStatusAsString() {
        return this.registrationStatus;
    }

    public final Integer maximumPageSize() {
        return this.maximumPageSize;
    }

    public final Boolean reverseOrder() {
        return this.reverseOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumPageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.reverseOrder());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainsRequest)) {
            return false;
        }
        ListDomainsRequest other = (ListDomainsRequest)((Object)obj);
        return Objects.equals(this.nextPageToken(), other.nextPageToken()) && Objects.equals(this.registrationStatusAsString(), other.registrationStatusAsString()) && Objects.equals(this.maximumPageSize(), other.maximumPageSize()) && Objects.equals(this.reverseOrder(), other.reverseOrder());
    }

    public final String toString() {
        return ToString.builder((String)"ListDomainsRequest").add("NextPageToken", (Object)this.nextPageToken()).add("RegistrationStatus", (Object)this.registrationStatusAsString()).add("MaximumPageSize", (Object)this.maximumPageSize()).add("ReverseOrder", (Object)this.reverseOrder()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
            case "registrationStatus": {
                return Optional.ofNullable(clazz.cast(this.registrationStatusAsString()));
            }
            case "maximumPageSize": {
                return Optional.ofNullable(clazz.cast(this.maximumPageSize()));
            }
            case "reverseOrder": {
                return Optional.ofNullable(clazz.cast(this.reverseOrder()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListDomainsRequest, T> g) {
        return obj -> g.apply((ListDomainsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SwfRequest.BuilderImpl
    implements Builder {
        private String nextPageToken;
        private String registrationStatus;
        private Integer maximumPageSize;
        private Boolean reverseOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainsRequest model) {
            super(model);
            this.nextPageToken(model.nextPageToken);
            this.registrationStatus(model.registrationStatus);
            this.maximumPageSize(model.maximumPageSize);
            this.reverseOrder(model.reverseOrder);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final String getRegistrationStatus() {
            return this.registrationStatus;
        }

        public final void setRegistrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
        }

        @Override
        public final Builder registrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
            return this;
        }

        @Override
        public final Builder registrationStatus(RegistrationStatus registrationStatus) {
            this.registrationStatus(registrationStatus == null ? null : registrationStatus.toString());
            return this;
        }

        public final Integer getMaximumPageSize() {
            return this.maximumPageSize;
        }

        public final void setMaximumPageSize(Integer maximumPageSize) {
            this.maximumPageSize = maximumPageSize;
        }

        @Override
        public final Builder maximumPageSize(Integer maximumPageSize) {
            this.maximumPageSize = maximumPageSize;
            return this;
        }

        public final Boolean getReverseOrder() {
            return this.reverseOrder;
        }

        public final void setReverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public final Builder reverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDomainsRequest build() {
            return new ListDomainsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SwfRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDomainsRequest> {
        public Builder nextPageToken(String var1);

        public Builder registrationStatus(String var1);

        public Builder registrationStatus(RegistrationStatus var1);

        public Builder maximumPageSize(Integer var1);

        public Builder reverseOrder(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

