/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.swf.SwfAsyncClient;
import software.amazon.awssdk.services.swf.model.HistoryEvent;
import software.amazon.awssdk.services.swf.model.PollForDecisionTaskRequest;
import software.amazon.awssdk.services.swf.model.PollForDecisionTaskResponse;

public class PollForDecisionTaskPublisher
implements SdkPublisher<PollForDecisionTaskResponse> {
    private final SwfAsyncClient client;
    private final PollForDecisionTaskRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public PollForDecisionTaskPublisher(SwfAsyncClient client, PollForDecisionTaskRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private PollForDecisionTaskPublisher(SwfAsyncClient client, PollForDecisionTaskRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new PollForDecisionTaskResponseFetcher();
    }

    public void subscribe(Subscriber<? super PollForDecisionTaskResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<HistoryEvent> events() {
        Function<PollForDecisionTaskResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new PollForDecisionTaskResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class PollForDecisionTaskResponseFetcher
    implements AsyncPageFetcher<PollForDecisionTaskResponse> {
        private PollForDecisionTaskResponseFetcher() {
        }

        public boolean hasNextPage(PollForDecisionTaskResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<PollForDecisionTaskResponse> nextPage(PollForDecisionTaskResponse previousPage) {
            if (previousPage == null) {
                return PollForDecisionTaskPublisher.this.client.pollForDecisionTask(PollForDecisionTaskPublisher.this.firstRequest);
            }
            return PollForDecisionTaskPublisher.this.client.pollForDecisionTask((PollForDecisionTaskRequest)((Object)PollForDecisionTaskPublisher.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

