/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of the <code>TimerStarted</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimerStartedEventAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<TimerStartedEventAttributes.Builder, TimerStartedEventAttributes> {
    private static final SdkField<String> TIMER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timerId").getter(getter(TimerStartedEventAttributes::timerId)).setter(setter(Builder::timerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timerId").build()).build();

    private static final SdkField<String> CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("control")
            .getter(getter(TimerStartedEventAttributes::control)).setter(setter(Builder::control))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("control").build()).build();

    private static final SdkField<String> START_TO_FIRE_TIMEOUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startToFireTimeout").getter(getter(TimerStartedEventAttributes::startToFireTimeout))
            .setter(setter(Builder::startToFireTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startToFireTimeout").build())
            .build();

    private static final SdkField<Long> DECISION_TASK_COMPLETED_EVENT_ID_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("decisionTaskCompletedEventId")
            .getter(getter(TimerStartedEventAttributes::decisionTaskCompletedEventId))
            .setter(setter(Builder::decisionTaskCompletedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decisionTaskCompletedEventId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMER_ID_FIELD, CONTROL_FIELD,
            START_TO_FIRE_TIMEOUT_FIELD, DECISION_TASK_COMPLETED_EVENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String timerId;

    private final String control;

    private final String startToFireTimeout;

    private final Long decisionTaskCompletedEventId;

    private TimerStartedEventAttributes(BuilderImpl builder) {
        this.timerId = builder.timerId;
        this.control = builder.control;
        this.startToFireTimeout = builder.startToFireTimeout;
        this.decisionTaskCompletedEventId = builder.decisionTaskCompletedEventId;
    }

    /**
     * <p>
     * The unique ID of the timer that was started.
     * </p>
     * 
     * @return The unique ID of the timer that was started.
     */
    public final String timerId() {
        return timerId;
    }

    /**
     * <p>
     * Data attached to the event that can be used by the decider in subsequent workflow tasks.
     * </p>
     * 
     * @return Data attached to the event that can be used by the decider in subsequent workflow tasks.
     */
    public final String control() {
        return control;
    }

    /**
     * <p>
     * The duration of time after which the timer fires.
     * </p>
     * <p>
     * The duration is specified in seconds, an integer greater than or equal to <code>0</code>.
     * </p>
     * 
     * @return The duration of time after which the timer fires.</p>
     *         <p>
     *         The duration is specified in seconds, an integer greater than or equal to <code>0</code>.
     */
    public final String startToFireTimeout() {
        return startToFireTimeout;
    }

    /**
     * <p>
     * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
     * <code>StartTimer</code> decision for this activity task. This information can be useful for diagnosing problems
     * by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted
     *         in the <code>StartTimer</code> decision for this activity task. This information can be useful for
     *         diagnosing problems by tracing back the chain of events leading up to this event.
     */
    public final Long decisionTaskCompletedEventId() {
        return decisionTaskCompletedEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timerId());
        hashCode = 31 * hashCode + Objects.hashCode(control());
        hashCode = 31 * hashCode + Objects.hashCode(startToFireTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(decisionTaskCompletedEventId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimerStartedEventAttributes)) {
            return false;
        }
        TimerStartedEventAttributes other = (TimerStartedEventAttributes) obj;
        return Objects.equals(timerId(), other.timerId()) && Objects.equals(control(), other.control())
                && Objects.equals(startToFireTimeout(), other.startToFireTimeout())
                && Objects.equals(decisionTaskCompletedEventId(), other.decisionTaskCompletedEventId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimerStartedEventAttributes").add("TimerId", timerId()).add("Control", control())
                .add("StartToFireTimeout", startToFireTimeout())
                .add("DecisionTaskCompletedEventId", decisionTaskCompletedEventId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timerId":
            return Optional.ofNullable(clazz.cast(timerId()));
        case "control":
            return Optional.ofNullable(clazz.cast(control()));
        case "startToFireTimeout":
            return Optional.ofNullable(clazz.cast(startToFireTimeout()));
        case "decisionTaskCompletedEventId":
            return Optional.ofNullable(clazz.cast(decisionTaskCompletedEventId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimerStartedEventAttributes, T> g) {
        return obj -> g.apply((TimerStartedEventAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimerStartedEventAttributes> {
        /**
         * <p>
         * The unique ID of the timer that was started.
         * </p>
         * 
         * @param timerId
         *        The unique ID of the timer that was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timerId(String timerId);

        /**
         * <p>
         * Data attached to the event that can be used by the decider in subsequent workflow tasks.
         * </p>
         * 
         * @param control
         *        Data attached to the event that can be used by the decider in subsequent workflow tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder control(String control);

        /**
         * <p>
         * The duration of time after which the timer fires.
         * </p>
         * <p>
         * The duration is specified in seconds, an integer greater than or equal to <code>0</code>.
         * </p>
         * 
         * @param startToFireTimeout
         *        The duration of time after which the timer fires.</p>
         *        <p>
         *        The duration is specified in seconds, an integer greater than or equal to <code>0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startToFireTimeout(String startToFireTimeout);

        /**
         * <p>
         * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in
         * the <code>StartTimer</code> decision for this activity task. This information can be useful for diagnosing
         * problems by tracing back the chain of events leading up to this event.
         * </p>
         * 
         * @param decisionTaskCompletedEventId
         *        The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that
         *        resulted in the <code>StartTimer</code> decision for this activity task. This information can be
         *        useful for diagnosing problems by tracing back the chain of events leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId);
    }

    static final class BuilderImpl implements Builder {
        private String timerId;

        private String control;

        private String startToFireTimeout;

        private Long decisionTaskCompletedEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(TimerStartedEventAttributes model) {
            timerId(model.timerId);
            control(model.control);
            startToFireTimeout(model.startToFireTimeout);
            decisionTaskCompletedEventId(model.decisionTaskCompletedEventId);
        }

        public final String getTimerId() {
            return timerId;
        }

        @Override
        public final Builder timerId(String timerId) {
            this.timerId = timerId;
            return this;
        }

        public final void setTimerId(String timerId) {
            this.timerId = timerId;
        }

        public final String getControl() {
            return control;
        }

        @Override
        public final Builder control(String control) {
            this.control = control;
            return this;
        }

        public final void setControl(String control) {
            this.control = control;
        }

        public final String getStartToFireTimeout() {
            return startToFireTimeout;
        }

        @Override
        public final Builder startToFireTimeout(String startToFireTimeout) {
            this.startToFireTimeout = startToFireTimeout;
            return this;
        }

        public final void setStartToFireTimeout(String startToFireTimeout) {
            this.startToFireTimeout = startToFireTimeout;
        }

        public final Long getDecisionTaskCompletedEventId() {
            return decisionTaskCompletedEventId;
        }

        @Override
        public final Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
            return this;
        }

        public final void setDecisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
        }

        @Override
        public TimerStartedEventAttributes build() {
            return new TimerStartedEventAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
