/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the <code>runId</code> of a workflow execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartWorkflowExecutionResponse extends SwfResponse implements
        ToCopyableBuilder<StartWorkflowExecutionResponse.Builder, StartWorkflowExecutionResponse> {
    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("runId")
            .getter(getter(StartWorkflowExecutionResponse::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUN_ID_FIELD));

    private final String runId;

    private StartWorkflowExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.runId = builder.runId;
    }

    /**
     * <p>
     * The <code>runId</code> of a workflow execution. This ID is generated by the service and can be used to uniquely
     * identify the workflow execution within a domain.
     * </p>
     * 
     * @return The <code>runId</code> of a workflow execution. This ID is generated by the service and can be used to
     *         uniquely identify the workflow execution within a domain.
     */
    public final String runId() {
        return runId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartWorkflowExecutionResponse)) {
            return false;
        }
        StartWorkflowExecutionResponse other = (StartWorkflowExecutionResponse) obj;
        return Objects.equals(runId(), other.runId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartWorkflowExecutionResponse").add("RunId", runId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "runId":
            return Optional.ofNullable(clazz.cast(runId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartWorkflowExecutionResponse, T> g) {
        return obj -> g.apply((StartWorkflowExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SwfResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartWorkflowExecutionResponse> {
        /**
         * <p>
         * The <code>runId</code> of a workflow execution. This ID is generated by the service and can be used to
         * uniquely identify the workflow execution within a domain.
         * </p>
         * 
         * @param runId
         *        The <code>runId</code> of a workflow execution. This ID is generated by the service and can be used to
         *        uniquely identify the workflow execution within a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);
    }

    static final class BuilderImpl extends SwfResponse.BuilderImpl implements Builder {
        private String runId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartWorkflowExecutionResponse model) {
            super(model);
            runId(model.runId);
        }

        public final String getRunId() {
            return runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public StartWorkflowExecutionResponse build() {
            return new StartWorkflowExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
