/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.SwfResponse;
import software.amazon.awssdk.services.swf.model.WorkflowTypeConfiguration;
import software.amazon.awssdk.services.swf.model.WorkflowTypeInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorkflowTypeResponse
extends SwfResponse
implements ToCopyableBuilder<Builder, DescribeWorkflowTypeResponse> {
    private static final SdkField<WorkflowTypeInfo> TYPE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeWorkflowTypeResponse.getter(DescribeWorkflowTypeResponse::typeInfo)).setter(DescribeWorkflowTypeResponse.setter(Builder::typeInfo)).constructor(WorkflowTypeInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeInfo").build()}).build();
    private static final SdkField<WorkflowTypeConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeWorkflowTypeResponse.getter(DescribeWorkflowTypeResponse::configuration)).setter(DescribeWorkflowTypeResponse.setter(Builder::configuration)).constructor(WorkflowTypeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_INFO_FIELD, CONFIGURATION_FIELD));
    private final WorkflowTypeInfo typeInfo;
    private final WorkflowTypeConfiguration configuration;

    private DescribeWorkflowTypeResponse(BuilderImpl builder) {
        super(builder);
        this.typeInfo = builder.typeInfo;
        this.configuration = builder.configuration;
    }

    public WorkflowTypeInfo typeInfo() {
        return this.typeInfo;
    }

    public WorkflowTypeConfiguration configuration() {
        return this.configuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.typeInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkflowTypeResponse)) {
            return false;
        }
        DescribeWorkflowTypeResponse other = (DescribeWorkflowTypeResponse)((Object)obj);
        return Objects.equals(this.typeInfo(), other.typeInfo()) && Objects.equals(this.configuration(), other.configuration());
    }

    public String toString() {
        return ToString.builder((String)"DescribeWorkflowTypeResponse").add("TypeInfo", (Object)this.typeInfo()).add("Configuration", (Object)this.configuration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "typeInfo": {
                return Optional.ofNullable(clazz.cast(this.typeInfo()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkflowTypeResponse, T> g) {
        return obj -> g.apply((DescribeWorkflowTypeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SwfResponse.BuilderImpl
    implements Builder {
        private WorkflowTypeInfo typeInfo;
        private WorkflowTypeConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkflowTypeResponse model) {
            super(model);
            this.typeInfo(model.typeInfo);
            this.configuration(model.configuration);
        }

        public final WorkflowTypeInfo.Builder getTypeInfo() {
            return this.typeInfo != null ? this.typeInfo.toBuilder() : null;
        }

        @Override
        public final Builder typeInfo(WorkflowTypeInfo typeInfo) {
            this.typeInfo = typeInfo;
            return this;
        }

        public final void setTypeInfo(WorkflowTypeInfo.BuilderImpl typeInfo) {
            this.typeInfo = typeInfo != null ? typeInfo.build() : null;
        }

        public final WorkflowTypeConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(WorkflowTypeConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(WorkflowTypeConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public DescribeWorkflowTypeResponse build() {
            return new DescribeWorkflowTypeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SwfResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorkflowTypeResponse> {
        public Builder typeInfo(WorkflowTypeInfo var1);

        default public Builder typeInfo(Consumer<WorkflowTypeInfo.Builder> typeInfo) {
            return this.typeInfo((WorkflowTypeInfo)((WorkflowTypeInfo.Builder)WorkflowTypeInfo.builder().applyMutation(typeInfo)).build());
        }

        public Builder configuration(WorkflowTypeConfiguration var1);

        default public Builder configuration(Consumer<WorkflowTypeConfiguration.Builder> configuration) {
            return this.configuration((WorkflowTypeConfiguration)((WorkflowTypeConfiguration.Builder)WorkflowTypeConfiguration.builder().applyMutation(configuration)).build());
        }
    }
}

