/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supportapp.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NotificationSeverityLevel {
    NONE("none"),
    ALL("all"),
    HIGH("high"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NotificationSeverityLevel> VALUE_MAP;
    private final String value;

    private NotificationSeverityLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NotificationSeverityLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NotificationSeverityLevel> knownValues() {
        EnumSet<NotificationSeverityLevel> knownValues = EnumSet.allOf(NotificationSeverityLevel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NotificationSeverityLevel.class, NotificationSeverityLevel::toString);
    }
}

