/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.support.model.CommunicationTypeOptions;
import software.amazon.awssdk.services.support.model.CommunicationTypeOptionsListCopier;
import software.amazon.awssdk.services.support.model.SupportResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCreateCaseOptionsResponse
extends SupportResponse
implements ToCopyableBuilder<Builder, DescribeCreateCaseOptionsResponse> {
    private static final SdkField<String> LANGUAGE_AVAILABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("languageAvailability").getter(DescribeCreateCaseOptionsResponse.getter(DescribeCreateCaseOptionsResponse::languageAvailability)).setter(DescribeCreateCaseOptionsResponse.setter(Builder::languageAvailability)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageAvailability").build()}).build();
    private static final SdkField<List<CommunicationTypeOptions>> COMMUNICATION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("communicationTypes").getter(DescribeCreateCaseOptionsResponse.getter(DescribeCreateCaseOptionsResponse::communicationTypes)).setter(DescribeCreateCaseOptionsResponse.setter(Builder::communicationTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("communicationTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CommunicationTypeOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_AVAILABILITY_FIELD, COMMUNICATION_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeCreateCaseOptionsResponse.memberNameToFieldInitializer();
    private final String languageAvailability;
    private final List<CommunicationTypeOptions> communicationTypes;

    private DescribeCreateCaseOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.languageAvailability = builder.languageAvailability;
        this.communicationTypes = builder.communicationTypes;
    }

    public final String languageAvailability() {
        return this.languageAvailability;
    }

    public final boolean hasCommunicationTypes() {
        return this.communicationTypes != null && !(this.communicationTypes instanceof SdkAutoConstructList);
    }

    public final List<CommunicationTypeOptions> communicationTypes() {
        return this.communicationTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.languageAvailability());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommunicationTypes() ? this.communicationTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCreateCaseOptionsResponse)) {
            return false;
        }
        DescribeCreateCaseOptionsResponse other = (DescribeCreateCaseOptionsResponse)((Object)obj);
        return Objects.equals(this.languageAvailability(), other.languageAvailability()) && this.hasCommunicationTypes() == other.hasCommunicationTypes() && Objects.equals(this.communicationTypes(), other.communicationTypes());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCreateCaseOptionsResponse").add("LanguageAvailability", (Object)this.languageAvailability()).add("CommunicationTypes", this.hasCommunicationTypes() ? this.communicationTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "languageAvailability": {
                return Optional.ofNullable(clazz.cast(this.languageAvailability()));
            }
            case "communicationTypes": {
                return Optional.ofNullable(clazz.cast(this.communicationTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("languageAvailability", LANGUAGE_AVAILABILITY_FIELD);
        map.put("communicationTypes", COMMUNICATION_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCreateCaseOptionsResponse, T> g) {
        return obj -> g.apply((DescribeCreateCaseOptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SupportResponse.BuilderImpl
    implements Builder {
        private String languageAvailability;
        private List<CommunicationTypeOptions> communicationTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCreateCaseOptionsResponse model) {
            super(model);
            this.languageAvailability(model.languageAvailability);
            this.communicationTypes(model.communicationTypes);
        }

        public final String getLanguageAvailability() {
            return this.languageAvailability;
        }

        public final void setLanguageAvailability(String languageAvailability) {
            this.languageAvailability = languageAvailability;
        }

        @Override
        public final Builder languageAvailability(String languageAvailability) {
            this.languageAvailability = languageAvailability;
            return this;
        }

        public final List<CommunicationTypeOptions.Builder> getCommunicationTypes() {
            List<CommunicationTypeOptions.Builder> result = CommunicationTypeOptionsListCopier.copyToBuilder(this.communicationTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCommunicationTypes(Collection<CommunicationTypeOptions.BuilderImpl> communicationTypes) {
            this.communicationTypes = CommunicationTypeOptionsListCopier.copyFromBuilder(communicationTypes);
        }

        @Override
        public final Builder communicationTypes(Collection<CommunicationTypeOptions> communicationTypes) {
            this.communicationTypes = CommunicationTypeOptionsListCopier.copy(communicationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder communicationTypes(CommunicationTypeOptions ... communicationTypes) {
            this.communicationTypes(Arrays.asList(communicationTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder communicationTypes(Consumer<CommunicationTypeOptions.Builder> ... communicationTypes) {
            this.communicationTypes(Stream.of(communicationTypes).map(c -> (CommunicationTypeOptions)((CommunicationTypeOptions.Builder)CommunicationTypeOptions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeCreateCaseOptionsResponse build() {
            return new DescribeCreateCaseOptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SupportResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCreateCaseOptionsResponse> {
        public Builder languageAvailability(String var1);

        public Builder communicationTypes(Collection<CommunicationTypeOptions> var1);

        public Builder communicationTypes(CommunicationTypeOptions ... var1);

        public Builder communicationTypes(Consumer<CommunicationTypeOptions.Builder> ... var1);
    }
}

