/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.support.SupportAsyncClient;
import software.amazon.awssdk.services.support.internal.UserAgentUtils;
import software.amazon.awssdk.services.support.model.CaseDetails;
import software.amazon.awssdk.services.support.model.DescribeCasesRequest;
import software.amazon.awssdk.services.support.model.DescribeCasesResponse;

public class DescribeCasesPublisher
implements SdkPublisher<DescribeCasesResponse> {
    private final SupportAsyncClient client;
    private final DescribeCasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCasesPublisher(SupportAsyncClient client, DescribeCasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCasesPublisher(SupportAsyncClient client, DescribeCasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CaseDetails> cases() {
        Function<DescribeCasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.cases() != null) {
                return response.cases().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeCasesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeCasesResponseFetcher
    implements AsyncPageFetcher<DescribeCasesResponse> {
        private DescribeCasesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeCasesResponse> nextPage(DescribeCasesResponse previousPage) {
            if (previousPage == null) {
                return DescribeCasesPublisher.this.client.describeCases(DescribeCasesPublisher.this.firstRequest);
            }
            return DescribeCasesPublisher.this.client.describeCases((DescribeCasesRequest)((Object)DescribeCasesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

