/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.support.model.Communication;
import software.amazon.awssdk.services.support.model.CommunicationListCopier;
import software.amazon.awssdk.services.support.model.SupportResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCommunicationsResponse
extends SupportResponse
implements ToCopyableBuilder<Builder, DescribeCommunicationsResponse> {
    private static final SdkField<List<Communication>> COMMUNICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("communications").getter(DescribeCommunicationsResponse.getter(DescribeCommunicationsResponse::communications)).setter(DescribeCommunicationsResponse.setter(Builder::communications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("communications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Communication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeCommunicationsResponse.getter(DescribeCommunicationsResponse::nextToken)).setter(DescribeCommunicationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMUNICATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Communication> communications;
    private final String nextToken;

    private DescribeCommunicationsResponse(BuilderImpl builder) {
        super(builder);
        this.communications = builder.communications;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCommunications() {
        return this.communications != null && !(this.communications instanceof SdkAutoConstructList);
    }

    public final List<Communication> communications() {
        return this.communications;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommunications() ? this.communications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCommunicationsResponse)) {
            return false;
        }
        DescribeCommunicationsResponse other = (DescribeCommunicationsResponse)((Object)obj);
        return this.hasCommunications() == other.hasCommunications() && Objects.equals(this.communications(), other.communications()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCommunicationsResponse").add("Communications", this.hasCommunications() ? this.communications() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "communications": {
                return Optional.ofNullable(clazz.cast(this.communications()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCommunicationsResponse, T> g) {
        return obj -> g.apply((DescribeCommunicationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SupportResponse.BuilderImpl
    implements Builder {
        private List<Communication> communications = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCommunicationsResponse model) {
            super(model);
            this.communications(model.communications);
            this.nextToken(model.nextToken);
        }

        public final List<Communication.Builder> getCommunications() {
            List<Communication.Builder> result = CommunicationListCopier.copyToBuilder(this.communications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCommunications(Collection<Communication.BuilderImpl> communications) {
            this.communications = CommunicationListCopier.copyFromBuilder(communications);
        }

        @Override
        @Transient
        public final Builder communications(Collection<Communication> communications) {
            this.communications = CommunicationListCopier.copy(communications);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder communications(Communication ... communications) {
            this.communications(Arrays.asList(communications));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder communications(Consumer<Communication.Builder> ... communications) {
            this.communications(Stream.of(communications).map(c -> (Communication)((Communication.Builder)Communication.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeCommunicationsResponse build() {
            return new DescribeCommunicationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SupportResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCommunicationsResponse> {
        public Builder communications(Collection<Communication> var1);

        public Builder communications(Communication ... var1);

        public Builder communications(Consumer<Communication.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

