/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCaseRequest extends SupportRequest implements
        ToCopyableBuilder<CreateCaseRequest.Builder, CreateCaseRequest> {
    private static final SdkField<String> SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCaseRequest::subject)).setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subject").build()).build();

    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCaseRequest::serviceCode)).setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCode").build()).build();

    private static final SdkField<String> SEVERITY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCaseRequest::severityCode)).setter(setter(Builder::severityCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityCode").build()).build();

    private static final SdkField<String> CATEGORY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCaseRequest::categoryCode)).setter(setter(Builder::categoryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categoryCode").build()).build();

    private static final SdkField<String> COMMUNICATION_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCaseRequest::communicationBody)).setter(setter(Builder::communicationBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("communicationBody").build()).build();

    private static final SdkField<List<String>> CC_EMAIL_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateCaseRequest::ccEmailAddresses))
            .setter(setter(Builder::ccEmailAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ccEmailAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCaseRequest::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()).build();

    private static final SdkField<String> ISSUE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCaseRequest::issueType)).setter(setter(Builder::issueType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issueType").build()).build();

    private static final SdkField<String> ATTACHMENT_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCaseRequest::attachmentSetId)).setter(setter(Builder::attachmentSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentSetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBJECT_FIELD,
            SERVICE_CODE_FIELD, SEVERITY_CODE_FIELD, CATEGORY_CODE_FIELD, COMMUNICATION_BODY_FIELD, CC_EMAIL_ADDRESSES_FIELD,
            LANGUAGE_FIELD, ISSUE_TYPE_FIELD, ATTACHMENT_SET_ID_FIELD));

    private final String subject;

    private final String serviceCode;

    private final String severityCode;

    private final String categoryCode;

    private final String communicationBody;

    private final List<String> ccEmailAddresses;

    private final String language;

    private final String issueType;

    private final String attachmentSetId;

    private CreateCaseRequest(BuilderImpl builder) {
        super(builder);
        this.subject = builder.subject;
        this.serviceCode = builder.serviceCode;
        this.severityCode = builder.severityCode;
        this.categoryCode = builder.categoryCode;
        this.communicationBody = builder.communicationBody;
        this.ccEmailAddresses = builder.ccEmailAddresses;
        this.language = builder.language;
        this.issueType = builder.issueType;
        this.attachmentSetId = builder.attachmentSetId;
    }

    /**
     * <p>
     * The title of the AWS Support case.
     * </p>
     * 
     * @return The title of the AWS Support case.
     */
    public String subject() {
        return subject;
    }

    /**
     * <p>
     * The code for the AWS service returned by the call to <a>DescribeServices</a>.
     * </p>
     * 
     * @return The code for the AWS service returned by the call to <a>DescribeServices</a>.
     */
    public String serviceCode() {
        return serviceCode;
    }

    /**
     * <p>
     * The code for the severity level returned by the call to <a>DescribeSeverityLevels</a>.
     * </p>
     * <note>
     * <p>
     * The availability of severity levels depends on the support plan for the account.
     * </p>
     * </note>
     * 
     * @return The code for the severity level returned by the call to <a>DescribeSeverityLevels</a>.</p> <note>
     *         <p>
     *         The availability of severity levels depends on the support plan for the account.
     *         </p>
     */
    public String severityCode() {
        return severityCode;
    }

    /**
     * <p>
     * The category of problem for the AWS Support case.
     * </p>
     * 
     * @return The category of problem for the AWS Support case.
     */
    public String categoryCode() {
        return categoryCode;
    }

    /**
     * <p>
     * The communication body text when you create an AWS Support case by calling <a>CreateCase</a>.
     * </p>
     * 
     * @return The communication body text when you create an AWS Support case by calling <a>CreateCase</a>.
     */
    public String communicationBody() {
        return communicationBody;
    }

    /**
     * Returns true if the CcEmailAddresses property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCcEmailAddresses() {
        return ccEmailAddresses != null && !(ccEmailAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of email addresses that AWS Support copies on case correspondence.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCcEmailAddresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of email addresses that AWS Support copies on case correspondence.
     */
    public List<String> ccEmailAddresses() {
        return ccEmailAddresses;
    }

    /**
     * <p>
     * The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English ("en")
     * and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
     * </p>
     * 
     * @return The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English
     *         ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
     */
    public String language() {
        return language;
    }

    /**
     * <p>
     * The type of issue for the case. You can specify either "customer-service" or "technical." If you do not indicate
     * a value, the default is "technical."
     * </p>
     * <note>
     * <p>
     * Service limit increases are not supported by the Support API; you must submit service limit increase requests in
     * <a href="https://console.aws.amazon.com/support">Support Center</a>.
     * </p>
     * </note>
     * 
     * @return The type of issue for the case. You can specify either "customer-service" or "technical." If you do not
     *         indicate a value, the default is "technical."</p> <note>
     *         <p>
     *         Service limit increases are not supported by the Support API; you must submit service limit increase
     *         requests in <a href="https://console.aws.amazon.com/support">Support Center</a>.
     *         </p>
     */
    public String issueType() {
        return issueType;
    }

    /**
     * <p>
     * The ID of a set of one or more attachments for the case. Create the set by using <a>AddAttachmentsToSet</a>.
     * </p>
     * 
     * @return The ID of a set of one or more attachments for the case. Create the set by using
     *         <a>AddAttachmentsToSet</a>.
     */
    public String attachmentSetId() {
        return attachmentSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(severityCode());
        hashCode = 31 * hashCode + Objects.hashCode(categoryCode());
        hashCode = 31 * hashCode + Objects.hashCode(communicationBody());
        hashCode = 31 * hashCode + Objects.hashCode(ccEmailAddresses());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        hashCode = 31 * hashCode + Objects.hashCode(issueType());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentSetId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCaseRequest)) {
            return false;
        }
        CreateCaseRequest other = (CreateCaseRequest) obj;
        return Objects.equals(subject(), other.subject()) && Objects.equals(serviceCode(), other.serviceCode())
                && Objects.equals(severityCode(), other.severityCode()) && Objects.equals(categoryCode(), other.categoryCode())
                && Objects.equals(communicationBody(), other.communicationBody())
                && Objects.equals(ccEmailAddresses(), other.ccEmailAddresses()) && Objects.equals(language(), other.language())
                && Objects.equals(issueType(), other.issueType()) && Objects.equals(attachmentSetId(), other.attachmentSetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateCaseRequest").add("Subject", subject()).add("ServiceCode", serviceCode())
                .add("SeverityCode", severityCode()).add("CategoryCode", categoryCode())
                .add("CommunicationBody", communicationBody()).add("CcEmailAddresses", ccEmailAddresses())
                .add("Language", language()).add("IssueType", issueType()).add("AttachmentSetId", attachmentSetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "serviceCode":
            return Optional.ofNullable(clazz.cast(serviceCode()));
        case "severityCode":
            return Optional.ofNullable(clazz.cast(severityCode()));
        case "categoryCode":
            return Optional.ofNullable(clazz.cast(categoryCode()));
        case "communicationBody":
            return Optional.ofNullable(clazz.cast(communicationBody()));
        case "ccEmailAddresses":
            return Optional.ofNullable(clazz.cast(ccEmailAddresses()));
        case "language":
            return Optional.ofNullable(clazz.cast(language()));
        case "issueType":
            return Optional.ofNullable(clazz.cast(issueType()));
        case "attachmentSetId":
            return Optional.ofNullable(clazz.cast(attachmentSetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCaseRequest, T> g) {
        return obj -> g.apply((CreateCaseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupportRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCaseRequest> {
        /**
         * <p>
         * The title of the AWS Support case.
         * </p>
         * 
         * @param subject
         *        The title of the AWS Support case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);

        /**
         * <p>
         * The code for the AWS service returned by the call to <a>DescribeServices</a>.
         * </p>
         * 
         * @param serviceCode
         *        The code for the AWS service returned by the call to <a>DescribeServices</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);

        /**
         * <p>
         * The code for the severity level returned by the call to <a>DescribeSeverityLevels</a>.
         * </p>
         * <note>
         * <p>
         * The availability of severity levels depends on the support plan for the account.
         * </p>
         * </note>
         * 
         * @param severityCode
         *        The code for the severity level returned by the call to <a>DescribeSeverityLevels</a>.</p> <note>
         *        <p>
         *        The availability of severity levels depends on the support plan for the account.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityCode(String severityCode);

        /**
         * <p>
         * The category of problem for the AWS Support case.
         * </p>
         * 
         * @param categoryCode
         *        The category of problem for the AWS Support case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryCode(String categoryCode);

        /**
         * <p>
         * The communication body text when you create an AWS Support case by calling <a>CreateCase</a>.
         * </p>
         * 
         * @param communicationBody
         *        The communication body text when you create an AWS Support case by calling <a>CreateCase</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder communicationBody(String communicationBody);

        /**
         * <p>
         * A list of email addresses that AWS Support copies on case correspondence.
         * </p>
         * 
         * @param ccEmailAddresses
         *        A list of email addresses that AWS Support copies on case correspondence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ccEmailAddresses(Collection<String> ccEmailAddresses);

        /**
         * <p>
         * A list of email addresses that AWS Support copies on case correspondence.
         * </p>
         * 
         * @param ccEmailAddresses
         *        A list of email addresses that AWS Support copies on case correspondence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ccEmailAddresses(String... ccEmailAddresses);

        /**
         * <p>
         * The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports English
         * ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that take them.
         * </p>
         * 
         * @param language
         *        The ISO 639-1 code for the language in which AWS provides support. AWS Support currently supports
         *        English ("en") and Japanese ("ja"). Language parameters must be passed explicitly for operations that
         *        take them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        /**
         * <p>
         * The type of issue for the case. You can specify either "customer-service" or "technical." If you do not
         * indicate a value, the default is "technical."
         * </p>
         * <note>
         * <p>
         * Service limit increases are not supported by the Support API; you must submit service limit increase requests
         * in <a href="https://console.aws.amazon.com/support">Support Center</a>.
         * </p>
         * </note>
         * 
         * @param issueType
         *        The type of issue for the case. You can specify either "customer-service" or "technical." If you do
         *        not indicate a value, the default is "technical."</p> <note>
         *        <p>
         *        Service limit increases are not supported by the Support API; you must submit service limit increase
         *        requests in <a href="https://console.aws.amazon.com/support">Support Center</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issueType(String issueType);

        /**
         * <p>
         * The ID of a set of one or more attachments for the case. Create the set by using <a>AddAttachmentsToSet</a>.
         * </p>
         * 
         * @param attachmentSetId
         *        The ID of a set of one or more attachments for the case. Create the set by using
         *        <a>AddAttachmentsToSet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentSetId(String attachmentSetId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SupportRequest.BuilderImpl implements Builder {
        private String subject;

        private String serviceCode;

        private String severityCode;

        private String categoryCode;

        private String communicationBody;

        private List<String> ccEmailAddresses = DefaultSdkAutoConstructList.getInstance();

        private String language;

        private String issueType;

        private String attachmentSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCaseRequest model) {
            super(model);
            subject(model.subject);
            serviceCode(model.serviceCode);
            severityCode(model.severityCode);
            categoryCode(model.categoryCode);
            communicationBody(model.communicationBody);
            ccEmailAddresses(model.ccEmailAddresses);
            language(model.language);
            issueType(model.issueType);
            attachmentSetId(model.attachmentSetId);
        }

        public final String getSubject() {
            return subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        public final String getSeverityCode() {
            return severityCode;
        }

        @Override
        public final Builder severityCode(String severityCode) {
            this.severityCode = severityCode;
            return this;
        }

        public final void setSeverityCode(String severityCode) {
            this.severityCode = severityCode;
        }

        public final String getCategoryCode() {
            return categoryCode;
        }

        @Override
        public final Builder categoryCode(String categoryCode) {
            this.categoryCode = categoryCode;
            return this;
        }

        public final void setCategoryCode(String categoryCode) {
            this.categoryCode = categoryCode;
        }

        public final String getCommunicationBody() {
            return communicationBody;
        }

        @Override
        public final Builder communicationBody(String communicationBody) {
            this.communicationBody = communicationBody;
            return this;
        }

        public final void setCommunicationBody(String communicationBody) {
            this.communicationBody = communicationBody;
        }

        public final Collection<String> getCcEmailAddresses() {
            return ccEmailAddresses;
        }

        @Override
        public final Builder ccEmailAddresses(Collection<String> ccEmailAddresses) {
            this.ccEmailAddresses = CcEmailAddressListCopier.copy(ccEmailAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ccEmailAddresses(String... ccEmailAddresses) {
            ccEmailAddresses(Arrays.asList(ccEmailAddresses));
            return this;
        }

        public final void setCcEmailAddresses(Collection<String> ccEmailAddresses) {
            this.ccEmailAddresses = CcEmailAddressListCopier.copy(ccEmailAddresses);
        }

        public final String getLanguage() {
            return language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        public final String getIssueType() {
            return issueType;
        }

        @Override
        public final Builder issueType(String issueType) {
            this.issueType = issueType;
            return this;
        }

        public final void setIssueType(String issueType) {
            this.issueType = issueType;
        }

        public final String getAttachmentSetId() {
            return attachmentSetId;
        }

        @Override
        public final Builder attachmentSetId(String attachmentSetId) {
            this.attachmentSetId = attachmentSetId;
            return this;
        }

        public final void setAttachmentSetId(String attachmentSetId) {
            this.attachmentSetId = attachmentSetId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCaseRequest build() {
            return new CreateCaseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
