/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.support.model.CaseIdListCopier;
import software.amazon.awssdk.services.support.model.SupportRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCasesRequest
extends SupportRequest
implements ToCopyableBuilder<Builder, DescribeCasesRequest> {
    private static final SdkField<List<String>> CASE_ID_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeCasesRequest.getter(DescribeCasesRequest::caseIdList)).setter(DescribeCasesRequest.setter(Builder::caseIdList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseIdList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DISPLAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeCasesRequest.getter(DescribeCasesRequest::displayId)).setter(DescribeCasesRequest.setter(Builder::displayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayId").build()}).build();
    private static final SdkField<String> AFTER_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeCasesRequest.getter(DescribeCasesRequest::afterTime)).setter(DescribeCasesRequest.setter(Builder::afterTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterTime").build()}).build();
    private static final SdkField<String> BEFORE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeCasesRequest.getter(DescribeCasesRequest::beforeTime)).setter(DescribeCasesRequest.setter(Builder::beforeTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeTime").build()}).build();
    private static final SdkField<Boolean> INCLUDE_RESOLVED_CASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DescribeCasesRequest.getter(DescribeCasesRequest::includeResolvedCases)).setter(DescribeCasesRequest.setter(Builder::includeResolvedCases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeResolvedCases").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeCasesRequest.getter(DescribeCasesRequest::nextToken)).setter(DescribeCasesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeCasesRequest.getter(DescribeCasesRequest::maxResults)).setter(DescribeCasesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeCasesRequest.getter(DescribeCasesRequest::language)).setter(DescribeCasesRequest.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()}).build();
    private static final SdkField<Boolean> INCLUDE_COMMUNICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DescribeCasesRequest.getter(DescribeCasesRequest::includeCommunications)).setter(DescribeCasesRequest.setter(Builder::includeCommunications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeCommunications").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_ID_LIST_FIELD, DISPLAY_ID_FIELD, AFTER_TIME_FIELD, BEFORE_TIME_FIELD, INCLUDE_RESOLVED_CASES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, LANGUAGE_FIELD, INCLUDE_COMMUNICATIONS_FIELD));
    private final List<String> caseIdList;
    private final String displayId;
    private final String afterTime;
    private final String beforeTime;
    private final Boolean includeResolvedCases;
    private final String nextToken;
    private final Integer maxResults;
    private final String language;
    private final Boolean includeCommunications;

    private DescribeCasesRequest(BuilderImpl builder) {
        super(builder);
        this.caseIdList = builder.caseIdList;
        this.displayId = builder.displayId;
        this.afterTime = builder.afterTime;
        this.beforeTime = builder.beforeTime;
        this.includeResolvedCases = builder.includeResolvedCases;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.language = builder.language;
        this.includeCommunications = builder.includeCommunications;
    }

    public List<String> caseIdList() {
        return this.caseIdList;
    }

    public String displayId() {
        return this.displayId;
    }

    public String afterTime() {
        return this.afterTime;
    }

    public String beforeTime() {
        return this.beforeTime;
    }

    public Boolean includeResolvedCases() {
        return this.includeResolvedCases;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String language() {
        return this.language;
    }

    public Boolean includeCommunications() {
        return this.includeCommunications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.caseIdList());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.beforeTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeResolvedCases());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeCommunications());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCasesRequest)) {
            return false;
        }
        DescribeCasesRequest other = (DescribeCasesRequest)((Object)obj);
        return Objects.equals(this.caseIdList(), other.caseIdList()) && Objects.equals(this.displayId(), other.displayId()) && Objects.equals(this.afterTime(), other.afterTime()) && Objects.equals(this.beforeTime(), other.beforeTime()) && Objects.equals(this.includeResolvedCases(), other.includeResolvedCases()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.language(), other.language()) && Objects.equals(this.includeCommunications(), other.includeCommunications());
    }

    public String toString() {
        return ToString.builder((String)"DescribeCasesRequest").add("CaseIdList", this.caseIdList()).add("DisplayId", (Object)this.displayId()).add("AfterTime", (Object)this.afterTime()).add("BeforeTime", (Object)this.beforeTime()).add("IncludeResolvedCases", (Object)this.includeResolvedCases()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("Language", (Object)this.language()).add("IncludeCommunications", (Object)this.includeCommunications()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "caseIdList": {
                return Optional.ofNullable(clazz.cast(this.caseIdList()));
            }
            case "displayId": {
                return Optional.ofNullable(clazz.cast(this.displayId()));
            }
            case "afterTime": {
                return Optional.ofNullable(clazz.cast(this.afterTime()));
            }
            case "beforeTime": {
                return Optional.ofNullable(clazz.cast(this.beforeTime()));
            }
            case "includeResolvedCases": {
                return Optional.ofNullable(clazz.cast(this.includeResolvedCases()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "language": {
                return Optional.ofNullable(clazz.cast(this.language()));
            }
            case "includeCommunications": {
                return Optional.ofNullable(clazz.cast(this.includeCommunications()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCasesRequest, T> g) {
        return obj -> g.apply((DescribeCasesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SupportRequest.BuilderImpl
    implements Builder {
        private List<String> caseIdList = DefaultSdkAutoConstructList.getInstance();
        private String displayId;
        private String afterTime;
        private String beforeTime;
        private Boolean includeResolvedCases;
        private String nextToken;
        private Integer maxResults;
        private String language;
        private Boolean includeCommunications;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCasesRequest model) {
            super(model);
            this.caseIdList(model.caseIdList);
            this.displayId(model.displayId);
            this.afterTime(model.afterTime);
            this.beforeTime(model.beforeTime);
            this.includeResolvedCases(model.includeResolvedCases);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.language(model.language);
            this.includeCommunications(model.includeCommunications);
        }

        public final Collection<String> getCaseIdList() {
            return this.caseIdList;
        }

        @Override
        public final Builder caseIdList(Collection<String> caseIdList) {
            this.caseIdList = CaseIdListCopier.copy(caseIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder caseIdList(String ... caseIdList) {
            this.caseIdList(Arrays.asList(caseIdList));
            return this;
        }

        public final void setCaseIdList(Collection<String> caseIdList) {
            this.caseIdList = CaseIdListCopier.copy(caseIdList);
        }

        public final String getDisplayId() {
            return this.displayId;
        }

        @Override
        public final Builder displayId(String displayId) {
            this.displayId = displayId;
            return this;
        }

        public final void setDisplayId(String displayId) {
            this.displayId = displayId;
        }

        public final String getAfterTime() {
            return this.afterTime;
        }

        @Override
        public final Builder afterTime(String afterTime) {
            this.afterTime = afterTime;
            return this;
        }

        public final void setAfterTime(String afterTime) {
            this.afterTime = afterTime;
        }

        public final String getBeforeTime() {
            return this.beforeTime;
        }

        @Override
        public final Builder beforeTime(String beforeTime) {
            this.beforeTime = beforeTime;
            return this;
        }

        public final void setBeforeTime(String beforeTime) {
            this.beforeTime = beforeTime;
        }

        public final Boolean getIncludeResolvedCases() {
            return this.includeResolvedCases;
        }

        @Override
        public final Builder includeResolvedCases(Boolean includeResolvedCases) {
            this.includeResolvedCases = includeResolvedCases;
            return this;
        }

        public final void setIncludeResolvedCases(Boolean includeResolvedCases) {
            this.includeResolvedCases = includeResolvedCases;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getLanguage() {
            return this.language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        public final Boolean getIncludeCommunications() {
            return this.includeCommunications;
        }

        @Override
        public final Builder includeCommunications(Boolean includeCommunications) {
            this.includeCommunications = includeCommunications;
            return this;
        }

        public final void setIncludeCommunications(Boolean includeCommunications) {
            this.includeCommunications = includeCommunications;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeCasesRequest build() {
            return new DescribeCasesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SupportRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCasesRequest> {
        public Builder caseIdList(Collection<String> var1);

        public Builder caseIdList(String ... var1);

        public Builder displayId(String var1);

        public Builder afterTime(String var1);

        public Builder beforeTime(String var1);

        public Builder includeResolvedCases(Boolean var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder language(String var1);

        public Builder includeCommunications(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

