/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.support.model.ServiceCodeListCopier;
import software.amazon.awssdk.services.support.model.SupportRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeServicesRequest
extends SupportRequest
implements ToCopyableBuilder<Builder, DescribeServicesRequest> {
    private final List<String> serviceCodeList;
    private final String language;

    private DescribeServicesRequest(BuilderImpl builder) {
        super(builder);
        this.serviceCodeList = builder.serviceCodeList;
        this.language = builder.language;
    }

    public List<String> serviceCodeList() {
        return this.serviceCodeList;
    }

    public String language() {
        return this.language;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCodeList());
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServicesRequest)) {
            return false;
        }
        DescribeServicesRequest other = (DescribeServicesRequest)((Object)obj);
        return Objects.equals(this.serviceCodeList(), other.serviceCodeList()) && Objects.equals(this.language(), other.language());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.serviceCodeList() != null) {
            sb.append("ServiceCodeList: ").append(this.serviceCodeList()).append(",");
        }
        if (this.language() != null) {
            sb.append("Language: ").append(this.language()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceCodeList": {
                return Optional.of(clazz.cast(this.serviceCodeList()));
            }
            case "language": {
                return Optional.of(clazz.cast(this.language()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SupportRequest.BuilderImpl
    implements Builder {
        private List<String> serviceCodeList;
        private String language;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServicesRequest model) {
            this.serviceCodeList(model.serviceCodeList);
            this.language(model.language);
        }

        public final Collection<String> getServiceCodeList() {
            return this.serviceCodeList;
        }

        @Override
        public final Builder serviceCodeList(Collection<String> serviceCodeList) {
            this.serviceCodeList = ServiceCodeListCopier.copy(serviceCodeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceCodeList(String ... serviceCodeList) {
            this.serviceCodeList(Arrays.asList(serviceCodeList));
            return this;
        }

        public final void setServiceCodeList(Collection<String> serviceCodeList) {
            this.serviceCodeList = ServiceCodeListCopier.copy(serviceCodeList);
        }

        public final String getLanguage() {
            return this.language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeServicesRequest build() {
            return new DescribeServicesRequest(this);
        }
    }

    public static interface Builder
    extends SupportRequest.Builder,
    CopyableBuilder<Builder, DescribeServicesRequest> {
        public Builder serviceCodeList(Collection<String> var1);

        public Builder serviceCodeList(String ... var1);

        public Builder language(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

