/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.model.Category;
import software.amazon.awssdk.services.support.model.CategoryListCopier;
import software.amazon.awssdk.services.support.transform.ServiceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Service
implements StructuredPojo,
ToCopyableBuilder<Builder, Service> {
    private final String code;
    private final String name;
    private final List<Category> categories;

    private Service(BuilderImpl builder) {
        this.code = builder.code;
        this.name = builder.name;
        this.categories = builder.categories;
    }

    public String code() {
        return this.code;
    }

    public String name() {
        return this.name;
    }

    public List<Category> categories() {
        return this.categories;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.code() == null ? 0 : this.code().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.categories() == null ? 0 : this.categories().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service)obj;
        if (other.code() == null ^ this.code() == null) {
            return false;
        }
        if (other.code() != null && !other.code().equals(this.code())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.categories() == null ^ this.categories() == null) {
            return false;
        }
        return other.categories() == null || other.categories().equals(this.categories());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.code() != null) {
            sb.append("Code: ").append(this.code()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.categories() != null) {
            sb.append("Categories: ").append(this.categories()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "code": {
                return Optional.of(clazz.cast(this.code()));
            }
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "categories": {
                return Optional.of(clazz.cast(this.categories()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServiceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String code;
        private String name;
        private List<Category> categories;

        private BuilderImpl() {
        }

        private BuilderImpl(Service model) {
            this.code(model.code);
            this.name(model.name);
            this.categories(model.categories);
        }

        public final String getCode() {
            return this.code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<Category.Builder> getCategories() {
            return this.categories != null ? (Collection)this.categories.stream().map(Category::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder categories(Collection<Category> categories) {
            this.categories = CategoryListCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Category ... categories) {
            this.categories(Arrays.asList(categories));
            return this;
        }

        public final void setCategories(Collection<Category.BuilderImpl> categories) {
            this.categories = CategoryListCopier.copyFromBuilder(categories);
        }

        public Service build() {
            return new Service(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Service> {
        public Builder code(String var1);

        public Builder name(String var1);

        public Builder categories(Collection<Category> var1);

        public Builder categories(Category ... var1);
    }
}

