/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.support.model.StringListCopier;
import software.amazon.awssdk.services.support.transform.TrustedAdvisorResourceDetailMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrustedAdvisorResourceDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, TrustedAdvisorResourceDetail> {
    private final String status;
    private final String region;
    private final String resourceId;
    private final Boolean isSuppressed;
    private final List<String> metadata;

    private TrustedAdvisorResourceDetail(BuilderImpl builder) {
        this.status = builder.status;
        this.region = builder.region;
        this.resourceId = builder.resourceId;
        this.isSuppressed = builder.isSuppressed;
        this.metadata = builder.metadata;
    }

    public String status() {
        return this.status;
    }

    public String region() {
        return this.region;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public Boolean isSuppressed() {
        return this.isSuppressed;
    }

    public List<String> metadata() {
        return this.metadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isSuppressed());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorResourceDetail)) {
            return false;
        }
        TrustedAdvisorResourceDetail other = (TrustedAdvisorResourceDetail)obj;
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.isSuppressed(), other.isSuppressed()) && Objects.equals(this.metadata(), other.metadata());
    }

    public String toString() {
        return ToString.builder((String)"TrustedAdvisorResourceDetail").add("Status", (Object)this.status()).add("Region", (Object)this.region()).add("ResourceId", (Object)this.resourceId()).add("IsSuppressed", (Object)this.isSuppressed()).add("Metadata", this.metadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "isSuppressed": {
                return Optional.ofNullable(clazz.cast(this.isSuppressed()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrustedAdvisorResourceDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String region;
        private String resourceId;
        private Boolean isSuppressed;
        private List<String> metadata = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorResourceDetail model) {
            this.status(model.status);
            this.region(model.region);
            this.resourceId(model.resourceId);
            this.isSuppressed(model.isSuppressed);
            this.metadata(model.metadata);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Boolean getIsSuppressed() {
            return this.isSuppressed;
        }

        @Override
        public final Builder isSuppressed(Boolean isSuppressed) {
            this.isSuppressed = isSuppressed;
            return this;
        }

        public final void setIsSuppressed(Boolean isSuppressed) {
            this.isSuppressed = isSuppressed;
        }

        public final Collection<String> getMetadata() {
            return this.metadata;
        }

        @Override
        public final Builder metadata(Collection<String> metadata) {
            this.metadata = StringListCopier.copy(metadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadata(String ... metadata) {
            this.metadata(Arrays.asList(metadata));
            return this;
        }

        public final void setMetadata(Collection<String> metadata) {
            this.metadata = StringListCopier.copy(metadata);
        }

        public TrustedAdvisorResourceDetail build() {
            return new TrustedAdvisorResourceDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TrustedAdvisorResourceDetail> {
        public Builder status(String var1);

        public Builder region(String var1);

        public Builder resourceId(String var1);

        public Builder isSuppressed(Boolean var1);

        public Builder metadata(Collection<String> var1);

        public Builder metadata(String ... var1);
    }
}

