/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.support.model.AttachmentDetails;
import software.amazon.awssdk.services.support.model.AttachmentSetCopier;
import software.amazon.awssdk.services.support.transform.CommunicationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Communication
implements StructuredPojo,
ToCopyableBuilder<Builder, Communication> {
    private final String caseId;
    private final String body;
    private final String submittedBy;
    private final String timeCreated;
    private final List<AttachmentDetails> attachmentSet;

    private Communication(BuilderImpl builder) {
        this.caseId = builder.caseId;
        this.body = builder.body;
        this.submittedBy = builder.submittedBy;
        this.timeCreated = builder.timeCreated;
        this.attachmentSet = builder.attachmentSet;
    }

    public String caseId() {
        return this.caseId;
    }

    public String body() {
        return this.body;
    }

    public String submittedBy() {
        return this.submittedBy;
    }

    public String timeCreated() {
        return this.timeCreated;
    }

    public List<AttachmentDetails> attachmentSet() {
        return this.attachmentSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.caseId() == null ? 0 : this.caseId().hashCode());
        hashCode = 31 * hashCode + (this.body() == null ? 0 : this.body().hashCode());
        hashCode = 31 * hashCode + (this.submittedBy() == null ? 0 : this.submittedBy().hashCode());
        hashCode = 31 * hashCode + (this.timeCreated() == null ? 0 : this.timeCreated().hashCode());
        hashCode = 31 * hashCode + (this.attachmentSet() == null ? 0 : this.attachmentSet().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Communication)) {
            return false;
        }
        Communication other = (Communication)obj;
        if (other.caseId() == null ^ this.caseId() == null) {
            return false;
        }
        if (other.caseId() != null && !other.caseId().equals(this.caseId())) {
            return false;
        }
        if (other.body() == null ^ this.body() == null) {
            return false;
        }
        if (other.body() != null && !other.body().equals(this.body())) {
            return false;
        }
        if (other.submittedBy() == null ^ this.submittedBy() == null) {
            return false;
        }
        if (other.submittedBy() != null && !other.submittedBy().equals(this.submittedBy())) {
            return false;
        }
        if (other.timeCreated() == null ^ this.timeCreated() == null) {
            return false;
        }
        if (other.timeCreated() != null && !other.timeCreated().equals(this.timeCreated())) {
            return false;
        }
        if (other.attachmentSet() == null ^ this.attachmentSet() == null) {
            return false;
        }
        return other.attachmentSet() == null || other.attachmentSet().equals(this.attachmentSet());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.caseId() != null) {
            sb.append("CaseId: ").append(this.caseId()).append(",");
        }
        if (this.body() != null) {
            sb.append("Body: ").append(this.body()).append(",");
        }
        if (this.submittedBy() != null) {
            sb.append("SubmittedBy: ").append(this.submittedBy()).append(",");
        }
        if (this.timeCreated() != null) {
            sb.append("TimeCreated: ").append(this.timeCreated()).append(",");
        }
        if (this.attachmentSet() != null) {
            sb.append("AttachmentSet: ").append(this.attachmentSet()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CommunicationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String caseId;
        private String body;
        private String submittedBy;
        private String timeCreated;
        private List<AttachmentDetails> attachmentSet = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(Communication model) {
            this.setCaseId(model.caseId);
            this.setBody(model.body);
            this.setSubmittedBy(model.submittedBy);
            this.setTimeCreated(model.timeCreated);
            this.setAttachmentSet(model.attachmentSet);
        }

        public final String getCaseId() {
            return this.caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        public final String getBody() {
            return this.body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getSubmittedBy() {
            return this.submittedBy;
        }

        @Override
        public final Builder submittedBy(String submittedBy) {
            this.submittedBy = submittedBy;
            return this;
        }

        public final void setSubmittedBy(String submittedBy) {
            this.submittedBy = submittedBy;
        }

        public final String getTimeCreated() {
            return this.timeCreated;
        }

        @Override
        public final Builder timeCreated(String timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public final void setTimeCreated(String timeCreated) {
            this.timeCreated = timeCreated;
        }

        public final Collection<AttachmentDetails> getAttachmentSet() {
            return this.attachmentSet;
        }

        @Override
        public final Builder attachmentSet(Collection<AttachmentDetails> attachmentSet) {
            this.attachmentSet = AttachmentSetCopier.copy(attachmentSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentSet(AttachmentDetails ... attachmentSet) {
            if (this.attachmentSet == null) {
                this.attachmentSet = new SdkInternalList(attachmentSet.length);
            }
            for (AttachmentDetails e : attachmentSet) {
                this.attachmentSet.add(e);
            }
            return this;
        }

        public final void setAttachmentSet(Collection<AttachmentDetails> attachmentSet) {
            this.attachmentSet = AttachmentSetCopier.copy(attachmentSet);
        }

        @SafeVarargs
        public final void setAttachmentSet(AttachmentDetails ... attachmentSet) {
            if (this.attachmentSet == null) {
                this.attachmentSet = new SdkInternalList(attachmentSet.length);
            }
            for (AttachmentDetails e : attachmentSet) {
                this.attachmentSet.add(e);
            }
        }

        public Communication build() {
            return new Communication(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Communication> {
        public Builder caseId(String var1);

        public Builder body(String var1);

        public Builder submittedBy(String var1);

        public Builder timeCreated(String var1);

        public Builder attachmentSet(Collection<AttachmentDetails> var1);

        public Builder attachmentSet(AttachmentDetails ... var1);
    }
}

