/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.support.model.CcEmailAddressListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AddCommunicationToCaseRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AddCommunicationToCaseRequest> {
    private final String caseId;
    private final String communicationBody;
    private final List<String> ccEmailAddresses;
    private final String attachmentSetId;

    private AddCommunicationToCaseRequest(BuilderImpl builder) {
        this.caseId = builder.caseId;
        this.communicationBody = builder.communicationBody;
        this.ccEmailAddresses = builder.ccEmailAddresses;
        this.attachmentSetId = builder.attachmentSetId;
    }

    public String caseId() {
        return this.caseId;
    }

    public String communicationBody() {
        return this.communicationBody;
    }

    public List<String> ccEmailAddresses() {
        return this.ccEmailAddresses;
    }

    public String attachmentSetId() {
        return this.attachmentSetId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.caseId() == null ? 0 : this.caseId().hashCode());
        hashCode = 31 * hashCode + (this.communicationBody() == null ? 0 : this.communicationBody().hashCode());
        hashCode = 31 * hashCode + (this.ccEmailAddresses() == null ? 0 : this.ccEmailAddresses().hashCode());
        hashCode = 31 * hashCode + (this.attachmentSetId() == null ? 0 : this.attachmentSetId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddCommunicationToCaseRequest)) {
            return false;
        }
        AddCommunicationToCaseRequest other = (AddCommunicationToCaseRequest)((Object)obj);
        if (other.caseId() == null ^ this.caseId() == null) {
            return false;
        }
        if (other.caseId() != null && !other.caseId().equals(this.caseId())) {
            return false;
        }
        if (other.communicationBody() == null ^ this.communicationBody() == null) {
            return false;
        }
        if (other.communicationBody() != null && !other.communicationBody().equals(this.communicationBody())) {
            return false;
        }
        if (other.ccEmailAddresses() == null ^ this.ccEmailAddresses() == null) {
            return false;
        }
        if (other.ccEmailAddresses() != null && !other.ccEmailAddresses().equals(this.ccEmailAddresses())) {
            return false;
        }
        if (other.attachmentSetId() == null ^ this.attachmentSetId() == null) {
            return false;
        }
        return other.attachmentSetId() == null || other.attachmentSetId().equals(this.attachmentSetId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.caseId() != null) {
            sb.append("CaseId: ").append(this.caseId()).append(",");
        }
        if (this.communicationBody() != null) {
            sb.append("CommunicationBody: ").append(this.communicationBody()).append(",");
        }
        if (this.ccEmailAddresses() != null) {
            sb.append("CcEmailAddresses: ").append(this.ccEmailAddresses()).append(",");
        }
        if (this.attachmentSetId() != null) {
            sb.append("AttachmentSetId: ").append(this.attachmentSetId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String caseId;
        private String communicationBody;
        private List<String> ccEmailAddresses = new SdkInternalList();
        private String attachmentSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(AddCommunicationToCaseRequest model) {
            this.setCaseId(model.caseId);
            this.setCommunicationBody(model.communicationBody);
            this.setCcEmailAddresses(model.ccEmailAddresses);
            this.setAttachmentSetId(model.attachmentSetId);
        }

        public final String getCaseId() {
            return this.caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        public final String getCommunicationBody() {
            return this.communicationBody;
        }

        @Override
        public final Builder communicationBody(String communicationBody) {
            this.communicationBody = communicationBody;
            return this;
        }

        public final void setCommunicationBody(String communicationBody) {
            this.communicationBody = communicationBody;
        }

        public final Collection<String> getCcEmailAddresses() {
            return this.ccEmailAddresses;
        }

        @Override
        public final Builder ccEmailAddresses(Collection<String> ccEmailAddresses) {
            this.ccEmailAddresses = CcEmailAddressListCopier.copy(ccEmailAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ccEmailAddresses(String ... ccEmailAddresses) {
            if (this.ccEmailAddresses == null) {
                this.ccEmailAddresses = new SdkInternalList(ccEmailAddresses.length);
            }
            for (String e : ccEmailAddresses) {
                this.ccEmailAddresses.add(e);
            }
            return this;
        }

        public final void setCcEmailAddresses(Collection<String> ccEmailAddresses) {
            this.ccEmailAddresses = CcEmailAddressListCopier.copy(ccEmailAddresses);
        }

        @SafeVarargs
        public final void setCcEmailAddresses(String ... ccEmailAddresses) {
            if (this.ccEmailAddresses == null) {
                this.ccEmailAddresses = new SdkInternalList(ccEmailAddresses.length);
            }
            for (String e : ccEmailAddresses) {
                this.ccEmailAddresses.add(e);
            }
        }

        public final String getAttachmentSetId() {
            return this.attachmentSetId;
        }

        @Override
        public final Builder attachmentSetId(String attachmentSetId) {
            this.attachmentSetId = attachmentSetId;
            return this;
        }

        public final void setAttachmentSetId(String attachmentSetId) {
            this.attachmentSetId = attachmentSetId;
        }

        public AddCommunicationToCaseRequest build() {
            return new AddCommunicationToCaseRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AddCommunicationToCaseRequest> {
        public Builder caseId(String var1);

        public Builder communicationBody(String var1);

        public Builder ccEmailAddresses(Collection<String> var1);

        public Builder ccEmailAddresses(String ... var1);

        public Builder attachmentSetId(String var1);
    }
}

