/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationEventDatasetLoadExecutionDetails;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationEventDatasetOperationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataIntegrationEventDatasetTargetDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataIntegrationEventDatasetTargetDetails> {
    private static final SdkField<String> DATASET_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetIdentifier").getter(DataIntegrationEventDatasetTargetDetails.getter(DataIntegrationEventDatasetTargetDetails::datasetIdentifier)).setter(DataIntegrationEventDatasetTargetDetails.setter(Builder::datasetIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetIdentifier").build()}).build();
    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operationType").getter(DataIntegrationEventDatasetTargetDetails.getter(DataIntegrationEventDatasetTargetDetails::operationTypeAsString)).setter(DataIntegrationEventDatasetTargetDetails.setter(Builder::operationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationType").build()}).build();
    private static final SdkField<DataIntegrationEventDatasetLoadExecutionDetails> DATASET_LOAD_EXECUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("datasetLoadExecution").getter(DataIntegrationEventDatasetTargetDetails.getter(DataIntegrationEventDatasetTargetDetails::datasetLoadExecution)).setter(DataIntegrationEventDatasetTargetDetails.setter(Builder::datasetLoadExecution)).constructor(DataIntegrationEventDatasetLoadExecutionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetLoadExecution").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_IDENTIFIER_FIELD, OPERATION_TYPE_FIELD, DATASET_LOAD_EXECUTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataIntegrationEventDatasetTargetDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String datasetIdentifier;
    private final String operationType;
    private final DataIntegrationEventDatasetLoadExecutionDetails datasetLoadExecution;

    private DataIntegrationEventDatasetTargetDetails(BuilderImpl builder) {
        this.datasetIdentifier = builder.datasetIdentifier;
        this.operationType = builder.operationType;
        this.datasetLoadExecution = builder.datasetLoadExecution;
    }

    public final String datasetIdentifier() {
        return this.datasetIdentifier;
    }

    public final DataIntegrationEventDatasetOperationType operationType() {
        return DataIntegrationEventDatasetOperationType.fromValue(this.operationType);
    }

    public final String operationTypeAsString() {
        return this.operationType;
    }

    public final DataIntegrationEventDatasetLoadExecutionDetails datasetLoadExecution() {
        return this.datasetLoadExecution;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetLoadExecution());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIntegrationEventDatasetTargetDetails)) {
            return false;
        }
        DataIntegrationEventDatasetTargetDetails other = (DataIntegrationEventDatasetTargetDetails)obj;
        return Objects.equals(this.datasetIdentifier(), other.datasetIdentifier()) && Objects.equals(this.operationTypeAsString(), other.operationTypeAsString()) && Objects.equals(this.datasetLoadExecution(), other.datasetLoadExecution());
    }

    public final String toString() {
        return ToString.builder((String)"DataIntegrationEventDatasetTargetDetails").add("DatasetIdentifier", (Object)this.datasetIdentifier()).add("OperationType", (Object)this.operationTypeAsString()).add("DatasetLoadExecution", (Object)this.datasetLoadExecution()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datasetIdentifier": {
                return Optional.ofNullable(clazz.cast(this.datasetIdentifier()));
            }
            case "operationType": {
                return Optional.ofNullable(clazz.cast(this.operationTypeAsString()));
            }
            case "datasetLoadExecution": {
                return Optional.ofNullable(clazz.cast(this.datasetLoadExecution()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("datasetIdentifier", DATASET_IDENTIFIER_FIELD);
        map.put("operationType", OPERATION_TYPE_FIELD);
        map.put("datasetLoadExecution", DATASET_LOAD_EXECUTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataIntegrationEventDatasetTargetDetails, T> g) {
        return obj -> g.apply((DataIntegrationEventDatasetTargetDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String datasetIdentifier;
        private String operationType;
        private DataIntegrationEventDatasetLoadExecutionDetails datasetLoadExecution;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIntegrationEventDatasetTargetDetails model) {
            this.datasetIdentifier(model.datasetIdentifier);
            this.operationType(model.operationType);
            this.datasetLoadExecution(model.datasetLoadExecution);
        }

        public final String getDatasetIdentifier() {
            return this.datasetIdentifier;
        }

        public final void setDatasetIdentifier(String datasetIdentifier) {
            this.datasetIdentifier = datasetIdentifier;
        }

        @Override
        public final Builder datasetIdentifier(String datasetIdentifier) {
            this.datasetIdentifier = datasetIdentifier;
            return this;
        }

        public final String getOperationType() {
            return this.operationType;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(DataIntegrationEventDatasetOperationType operationType) {
            this.operationType(operationType == null ? null : operationType.toString());
            return this;
        }

        public final DataIntegrationEventDatasetLoadExecutionDetails.Builder getDatasetLoadExecution() {
            return this.datasetLoadExecution != null ? this.datasetLoadExecution.toBuilder() : null;
        }

        public final void setDatasetLoadExecution(DataIntegrationEventDatasetLoadExecutionDetails.BuilderImpl datasetLoadExecution) {
            this.datasetLoadExecution = datasetLoadExecution != null ? datasetLoadExecution.build() : null;
        }

        @Override
        public final Builder datasetLoadExecution(DataIntegrationEventDatasetLoadExecutionDetails datasetLoadExecution) {
            this.datasetLoadExecution = datasetLoadExecution;
            return this;
        }

        public DataIntegrationEventDatasetTargetDetails build() {
            return new DataIntegrationEventDatasetTargetDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataIntegrationEventDatasetTargetDetails> {
        public Builder datasetIdentifier(String var1);

        public Builder operationType(String var1);

        public Builder operationType(DataIntegrationEventDatasetOperationType var1);

        public Builder datasetLoadExecution(DataIntegrationEventDatasetLoadExecutionDetails var1);

        default public Builder datasetLoadExecution(Consumer<DataIntegrationEventDatasetLoadExecutionDetails.Builder> datasetLoadExecution) {
            return this.datasetLoadExecution((DataIntegrationEventDatasetLoadExecutionDetails)((DataIntegrationEventDatasetLoadExecutionDetails.Builder)DataIntegrationEventDatasetLoadExecutionDetails.builder().applyMutation(datasetLoadExecution)).build());
        }
    }
}

