/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.supplychain.SupplyChainAsyncClient;
import software.amazon.awssdk.services.supplychain.internal.UserAgentUtils;
import software.amazon.awssdk.services.supplychain.model.DataLakeDataset;
import software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsRequest;
import software.amazon.awssdk.services.supplychain.model.ListDataLakeDatasetsResponse;

public class ListDataLakeDatasetsPublisher
implements SdkPublisher<ListDataLakeDatasetsResponse> {
    private final SupplyChainAsyncClient client;
    private final ListDataLakeDatasetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataLakeDatasetsPublisher(SupplyChainAsyncClient client, ListDataLakeDatasetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataLakeDatasetsPublisher(SupplyChainAsyncClient client, ListDataLakeDatasetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataLakeDatasetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataLakeDatasetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataLakeDataset> datasets() {
        Function<ListDataLakeDatasetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.datasets() != null) {
                return response.datasets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDataLakeDatasetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataLakeDatasetsResponseFetcher
    implements AsyncPageFetcher<ListDataLakeDatasetsResponse> {
        private ListDataLakeDatasetsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataLakeDatasetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataLakeDatasetsResponse> nextPage(ListDataLakeDatasetsResponse previousPage) {
            if (previousPage == null) {
                return ListDataLakeDatasetsPublisher.this.client.listDataLakeDatasets(ListDataLakeDatasetsPublisher.this.firstRequest);
            }
            return ListDataLakeDatasetsPublisher.this.client.listDataLakeDatasets((ListDataLakeDatasetsRequest)((Object)ListDataLakeDatasetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

