/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.supplychain.model.DataLakeDatasetPartitionField;
import software.amazon.awssdk.services.supplychain.model.DataLakeDatasetPartitionFieldListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataLakeDatasetPartitionSpec
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataLakeDatasetPartitionSpec> {
    private static final SdkField<List<DataLakeDatasetPartitionField>> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fields").getter(DataLakeDatasetPartitionSpec.getter(DataLakeDatasetPartitionSpec::fields)).setter(DataLakeDatasetPartitionSpec.setter(Builder::fields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataLakeDatasetPartitionField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataLakeDatasetPartitionSpec.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<DataLakeDatasetPartitionField> fields;

    private DataLakeDatasetPartitionSpec(BuilderImpl builder) {
        this.fields = builder.fields;
    }

    public final boolean hasFields() {
        return this.fields != null && !(this.fields instanceof SdkAutoConstructList);
    }

    public final List<DataLakeDatasetPartitionField> fields() {
        return this.fields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFields() ? this.fields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeDatasetPartitionSpec)) {
            return false;
        }
        DataLakeDatasetPartitionSpec other = (DataLakeDatasetPartitionSpec)obj;
        return this.hasFields() == other.hasFields() && Objects.equals(this.fields(), other.fields());
    }

    public final String toString() {
        return ToString.builder((String)"DataLakeDatasetPartitionSpec").add("Fields", this.hasFields() ? this.fields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fields": {
                return Optional.ofNullable(clazz.cast(this.fields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<DataLakeDatasetPartitionField>>> map = new HashMap<String, SdkField<List<DataLakeDatasetPartitionField>>>();
        map.put("fields", FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataLakeDatasetPartitionSpec, T> g) {
        return obj -> g.apply((DataLakeDatasetPartitionSpec)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DataLakeDatasetPartitionField> fields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeDatasetPartitionSpec model) {
            this.fields(model.fields);
        }

        public final List<DataLakeDatasetPartitionField.Builder> getFields() {
            List<DataLakeDatasetPartitionField.Builder> result = DataLakeDatasetPartitionFieldListCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<DataLakeDatasetPartitionField.BuilderImpl> fields) {
            this.fields = DataLakeDatasetPartitionFieldListCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<DataLakeDatasetPartitionField> fields) {
            this.fields = DataLakeDatasetPartitionFieldListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(DataLakeDatasetPartitionField ... fields) {
            this.fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<DataLakeDatasetPartitionField.Builder> ... fields) {
            this.fields(Stream.of(fields).map(c -> (DataLakeDatasetPartitionField)((DataLakeDatasetPartitionField.Builder)DataLakeDatasetPartitionField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DataLakeDatasetPartitionSpec build() {
            return new DataLakeDatasetPartitionSpec(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataLakeDatasetPartitionSpec> {
        public Builder fields(Collection<DataLakeDatasetPartitionField> var1);

        public Builder fields(DataLakeDatasetPartitionField ... var1);

        public Builder fields(Consumer<DataLakeDatasetPartitionField.Builder> ... var1);
    }
}

