/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowDatasetOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataIntegrationFlowDatasetSourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataIntegrationFlowDatasetSourceConfiguration> {
    private static final SdkField<String> DATASET_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetIdentifier").getter(DataIntegrationFlowDatasetSourceConfiguration.getter(DataIntegrationFlowDatasetSourceConfiguration::datasetIdentifier)).setter(DataIntegrationFlowDatasetSourceConfiguration.setter(Builder::datasetIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetIdentifier").build()}).build();
    private static final SdkField<DataIntegrationFlowDatasetOptions> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("options").getter(DataIntegrationFlowDatasetSourceConfiguration.getter(DataIntegrationFlowDatasetSourceConfiguration::options)).setter(DataIntegrationFlowDatasetSourceConfiguration.setter(Builder::options)).constructor(DataIntegrationFlowDatasetOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("options").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_IDENTIFIER_FIELD, OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataIntegrationFlowDatasetSourceConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String datasetIdentifier;
    private final DataIntegrationFlowDatasetOptions options;

    private DataIntegrationFlowDatasetSourceConfiguration(BuilderImpl builder) {
        this.datasetIdentifier = builder.datasetIdentifier;
        this.options = builder.options;
    }

    public final String datasetIdentifier() {
        return this.datasetIdentifier;
    }

    public final DataIntegrationFlowDatasetOptions options() {
        return this.options;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIntegrationFlowDatasetSourceConfiguration)) {
            return false;
        }
        DataIntegrationFlowDatasetSourceConfiguration other = (DataIntegrationFlowDatasetSourceConfiguration)obj;
        return Objects.equals(this.datasetIdentifier(), other.datasetIdentifier()) && Objects.equals(this.options(), other.options());
    }

    public final String toString() {
        return ToString.builder((String)"DataIntegrationFlowDatasetSourceConfiguration").add("DatasetIdentifier", (Object)this.datasetIdentifier()).add("Options", (Object)this.options()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datasetIdentifier": {
                return Optional.ofNullable(clazz.cast(this.datasetIdentifier()));
            }
            case "options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("datasetIdentifier", DATASET_IDENTIFIER_FIELD);
        map.put("options", OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataIntegrationFlowDatasetSourceConfiguration, T> g) {
        return obj -> g.apply((DataIntegrationFlowDatasetSourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String datasetIdentifier;
        private DataIntegrationFlowDatasetOptions options;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIntegrationFlowDatasetSourceConfiguration model) {
            this.datasetIdentifier(model.datasetIdentifier);
            this.options(model.options);
        }

        public final String getDatasetIdentifier() {
            return this.datasetIdentifier;
        }

        public final void setDatasetIdentifier(String datasetIdentifier) {
            this.datasetIdentifier = datasetIdentifier;
        }

        @Override
        public final Builder datasetIdentifier(String datasetIdentifier) {
            this.datasetIdentifier = datasetIdentifier;
            return this;
        }

        public final DataIntegrationFlowDatasetOptions.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        public final void setOptions(DataIntegrationFlowDatasetOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(DataIntegrationFlowDatasetOptions options) {
            this.options = options;
            return this;
        }

        public DataIntegrationFlowDatasetSourceConfiguration build() {
            return new DataIntegrationFlowDatasetSourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataIntegrationFlowDatasetSourceConfiguration> {
        public Builder datasetIdentifier(String var1);

        public Builder options(DataIntegrationFlowDatasetOptions var1);

        default public Builder options(Consumer<DataIntegrationFlowDatasetOptions.Builder> options) {
            return this.options((DataIntegrationFlowDatasetOptions)((DataIntegrationFlowDatasetOptions.Builder)DataIntegrationFlowDatasetOptions.builder().applyMutation(options)).build());
        }
    }
}

