/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.supplychain.model.DataLakeDataset;
import software.amazon.awssdk.services.supplychain.model.DataLakeDatasetListCopier;
import software.amazon.awssdk.services.supplychain.model.SupplyChainResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataLakeDatasetsResponse
extends SupplyChainResponse
implements ToCopyableBuilder<Builder, ListDataLakeDatasetsResponse> {
    private static final SdkField<List<DataLakeDataset>> DATASETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("datasets").getter(ListDataLakeDatasetsResponse.getter(ListDataLakeDatasetsResponse::datasets)).setter(ListDataLakeDatasetsResponse.setter(Builder::datasets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataLakeDataset::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDataLakeDatasetsResponse.getter(ListDataLakeDatasetsResponse::nextToken)).setter(ListDataLakeDatasetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASETS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("datasets", DATASETS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<DataLakeDataset> datasets;
    private final String nextToken;

    private ListDataLakeDatasetsResponse(BuilderImpl builder) {
        super(builder);
        this.datasets = builder.datasets;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDatasets() {
        return this.datasets != null && !(this.datasets instanceof SdkAutoConstructList);
    }

    public final List<DataLakeDataset> datasets() {
        return this.datasets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatasets() ? this.datasets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataLakeDatasetsResponse)) {
            return false;
        }
        ListDataLakeDatasetsResponse other = (ListDataLakeDatasetsResponse)((Object)obj);
        return this.hasDatasets() == other.hasDatasets() && Objects.equals(this.datasets(), other.datasets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDataLakeDatasetsResponse").add("Datasets", this.hasDatasets() ? this.datasets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datasets": {
                return Optional.ofNullable(clazz.cast(this.datasets()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListDataLakeDatasetsResponse, T> g) {
        return obj -> g.apply((ListDataLakeDatasetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SupplyChainResponse.BuilderImpl
    implements Builder {
        private List<DataLakeDataset> datasets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataLakeDatasetsResponse model) {
            super(model);
            this.datasets(model.datasets);
            this.nextToken(model.nextToken);
        }

        public final List<DataLakeDataset.Builder> getDatasets() {
            List<DataLakeDataset.Builder> result = DataLakeDatasetListCopier.copyToBuilder(this.datasets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatasets(Collection<DataLakeDataset.BuilderImpl> datasets) {
            this.datasets = DataLakeDatasetListCopier.copyFromBuilder(datasets);
        }

        @Override
        public final Builder datasets(Collection<DataLakeDataset> datasets) {
            this.datasets = DataLakeDatasetListCopier.copy(datasets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasets(DataLakeDataset ... datasets) {
            this.datasets(Arrays.asList(datasets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasets(Consumer<DataLakeDataset.Builder> ... datasets) {
            this.datasets(Stream.of(datasets).map(c -> (DataLakeDataset)((DataLakeDataset.Builder)DataLakeDataset.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDataLakeDatasetsResponse build() {
            return new ListDataLakeDatasetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SupplyChainResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataLakeDatasetsResponse> {
        public Builder datasets(Collection<DataLakeDataset> var1);

        public Builder datasets(DataLakeDataset ... var1);

        public Builder datasets(Consumer<DataLakeDataset.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

