/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.supplychain.model.InstanceState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Instance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Instance> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceId").getter(Instance.getter(Instance::instanceId)).setter(Instance.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceId").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsAccountId").getter(Instance.getter(Instance::awsAccountId)).setter(Instance.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(Instance.getter(Instance::stateAsString)).setter(Instance.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> WEB_APP_DNS_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("webAppDnsDomain").getter(Instance.getter(Instance::webAppDnsDomain)).setter(Instance.setter(Builder::webAppDnsDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webAppDnsDomain").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTime").getter(Instance.getter(Instance::createdTime)).setter(Instance.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTime").getter(Instance.getter(Instance::lastModifiedTime)).setter(Instance.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build()}).build();
    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceName").getter(Instance.getter(Instance::instanceName)).setter(Instance.setter(Builder::instanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceName").build()}).build();
    private static final SdkField<String> INSTANCE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceDescription").getter(Instance.getter(Instance::instanceDescription)).setter(Instance.setter(Builder::instanceDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceDescription").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(Instance.getter(Instance::kmsKeyArn)).setter(Instance.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final SdkField<Double> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("versionNumber").getter(Instance.getter(Instance::versionNumber)).setter(Instance.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, AWS_ACCOUNT_ID_FIELD, STATE_FIELD, WEB_APP_DNS_DOMAIN_FIELD, CREATED_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, INSTANCE_NAME_FIELD, INSTANCE_DESCRIPTION_FIELD, KMS_KEY_ARN_FIELD, VERSION_NUMBER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceId;
    private final String awsAccountId;
    private final String state;
    private final String webAppDnsDomain;
    private final Instant createdTime;
    private final Instant lastModifiedTime;
    private final String instanceName;
    private final String instanceDescription;
    private final String kmsKeyArn;
    private final Double versionNumber;

    private Instance(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.awsAccountId = builder.awsAccountId;
        this.state = builder.state;
        this.webAppDnsDomain = builder.webAppDnsDomain;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.instanceName = builder.instanceName;
        this.instanceDescription = builder.instanceDescription;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.versionNumber = builder.versionNumber;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final InstanceState state() {
        return InstanceState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String webAppDnsDomain() {
        return this.webAppDnsDomain;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String instanceName() {
        return this.instanceName;
    }

    public final String instanceDescription() {
        return this.instanceDescription;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final Double versionNumber() {
        return this.versionNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.webAppDnsDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.webAppDnsDomain(), other.webAppDnsDomain()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.instanceName(), other.instanceName()) && Objects.equals(this.instanceDescription(), other.instanceDescription()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.versionNumber(), other.versionNumber());
    }

    public final String toString() {
        return ToString.builder((String)"Instance").add("InstanceId", (Object)this.instanceId()).add("AwsAccountId", (Object)this.awsAccountId()).add("State", (Object)this.stateAsString()).add("WebAppDnsDomain", (Object)this.webAppDnsDomain()).add("CreatedTime", (Object)this.createdTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("InstanceName", (Object)this.instanceName()).add("InstanceDescription", (Object)this.instanceDescription()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("VersionNumber", (Object)this.versionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "awsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "webAppDnsDomain": {
                return Optional.ofNullable(clazz.cast(this.webAppDnsDomain()));
            }
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "instanceName": {
                return Optional.ofNullable(clazz.cast(this.instanceName()));
            }
            case "instanceDescription": {
                return Optional.ofNullable(clazz.cast(this.instanceDescription()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "versionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Instance, T> g) {
        return obj -> g.apply((Instance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String awsAccountId;
        private String state;
        private String webAppDnsDomain;
        private Instant createdTime;
        private Instant lastModifiedTime;
        private String instanceName;
        private String instanceDescription;
        private String kmsKeyArn;
        private Double versionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            this.instanceId(model.instanceId);
            this.awsAccountId(model.awsAccountId);
            this.state(model.state);
            this.webAppDnsDomain(model.webAppDnsDomain);
            this.createdTime(model.createdTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.instanceName(model.instanceName);
            this.instanceDescription(model.instanceDescription);
            this.kmsKeyArn(model.kmsKeyArn);
            this.versionNumber(model.versionNumber);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(InstanceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getWebAppDnsDomain() {
            return this.webAppDnsDomain;
        }

        public final void setWebAppDnsDomain(String webAppDnsDomain) {
            this.webAppDnsDomain = webAppDnsDomain;
        }

        @Override
        public final Builder webAppDnsDomain(String webAppDnsDomain) {
            this.webAppDnsDomain = webAppDnsDomain;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final String getInstanceDescription() {
            return this.instanceDescription;
        }

        public final void setInstanceDescription(String instanceDescription) {
            this.instanceDescription = instanceDescription;
        }

        @Override
        public final Builder instanceDescription(String instanceDescription) {
            this.instanceDescription = instanceDescription;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Double getVersionNumber() {
            return this.versionNumber;
        }

        public final void setVersionNumber(Double versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Double versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public Instance build() {
            return new Instance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Instance> {
        public Builder instanceId(String var1);

        public Builder awsAccountId(String var1);

        public Builder state(String var1);

        public Builder state(InstanceState var1);

        public Builder webAppDnsDomain(String var1);

        public Builder createdTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder instanceName(String var1);

        public Builder instanceDescription(String var1);

        public Builder kmsKeyArn(String var1);

        public Builder versionNumber(Double var1);
    }
}

