/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.sts.model.STSRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssumeRoleWithSAMLRequest
extends STSRequest
implements ToCopyableBuilder<Builder, AssumeRoleWithSAMLRequest> {
    private final String roleArn;
    private final String principalArn;
    private final String samlAssertion;
    private final String policy;
    private final Integer durationSeconds;

    private AssumeRoleWithSAMLRequest(BuilderImpl builder) {
        super(builder);
        this.roleArn = builder.roleArn;
        this.principalArn = builder.principalArn;
        this.samlAssertion = builder.samlAssertion;
        this.policy = builder.policy;
        this.durationSeconds = builder.durationSeconds;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String principalArn() {
        return this.principalArn;
    }

    public String samlAssertion() {
        return this.samlAssertion;
    }

    public String policy() {
        return this.policy;
    }

    public Integer durationSeconds() {
        return this.durationSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.samlAssertion());
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumeRoleWithSAMLRequest)) {
            return false;
        }
        AssumeRoleWithSAMLRequest other = (AssumeRoleWithSAMLRequest)((Object)obj);
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.principalArn(), other.principalArn()) && Objects.equals(this.samlAssertion(), other.samlAssertion()) && Objects.equals(this.policy(), other.policy()) && Objects.equals(this.durationSeconds(), other.durationSeconds());
    }

    public String toString() {
        return ToString.builder((String)"AssumeRoleWithSAMLRequest").add("RoleArn", (Object)this.roleArn()).add("PrincipalArn", (Object)this.principalArn()).add("SAMLAssertion", (Object)this.samlAssertion()).add("Policy", (Object)this.policy()).add("DurationSeconds", (Object)this.durationSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleArn": {
                return Optional.of(clazz.cast(this.roleArn()));
            }
            case "PrincipalArn": {
                return Optional.of(clazz.cast(this.principalArn()));
            }
            case "SAMLAssertion": {
                return Optional.of(clazz.cast(this.samlAssertion()));
            }
            case "Policy": {
                return Optional.of(clazz.cast(this.policy()));
            }
            case "DurationSeconds": {
                return Optional.of(clazz.cast(this.durationSeconds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends STSRequest.BuilderImpl
    implements Builder {
        private String roleArn;
        private String principalArn;
        private String samlAssertion;
        private String policy;
        private Integer durationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(AssumeRoleWithSAMLRequest model) {
            this.roleArn(model.roleArn);
            this.principalArn(model.principalArn);
            this.samlAssertion(model.samlAssertion);
            this.policy(model.policy);
            this.durationSeconds(model.durationSeconds);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getPrincipalArn() {
            return this.principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        public final String getSAMLAssertion() {
            return this.samlAssertion;
        }

        @Override
        public final Builder samlAssertion(String samlAssertion) {
            this.samlAssertion = samlAssertion;
            return this;
        }

        public final void setSAMLAssertion(String samlAssertion) {
            this.samlAssertion = samlAssertion;
        }

        public final String getPolicy() {
            return this.policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final Integer getDurationSeconds() {
            return this.durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AssumeRoleWithSAMLRequest build() {
            return new AssumeRoleWithSAMLRequest(this);
        }
    }

    public static interface Builder
    extends STSRequest.Builder,
    CopyableBuilder<Builder, AssumeRoleWithSAMLRequest> {
        public Builder roleArn(String var1);

        public Builder principalArn(String var1);

        public Builder samlAssertion(String var1);

        public Builder policy(String var1);

        public Builder durationSeconds(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

