/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.auth;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.auth.AwsCredentials;
import software.amazon.awssdk.core.auth.AwsCredentialsProvider;
import software.amazon.awssdk.services.sts.STSClient;
import software.amazon.awssdk.services.sts.auth.SessionCredentialsHolder;
import software.amazon.awssdk.services.sts.model.Credentials;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.cache.CachedSupplier;
import software.amazon.awssdk.utils.cache.NonBlocking;
import software.amazon.awssdk.utils.cache.RefreshResult;

@ThreadSafe
@SdkInternalApi
abstract class StsCredentialsProvider
implements AwsCredentialsProvider,
SdkAutoCloseable {
    private final STSClient stsClient;
    private final CachedSupplier<SessionCredentialsHolder> sessionCache;

    protected StsCredentialsProvider(BaseBuilder<?, ?> builder, String asyncThreadName) {
        this.stsClient = (STSClient)Validate.notNull((Object)((BaseBuilder)builder).stsClient, (String)"STS client must not be null.", (Object[])new Object[0]);
        CachedSupplier.Builder cacheBuilder = CachedSupplier.builder(this::updateSessionCredentials);
        if (((BaseBuilder)builder).asyncCredentialUpdateEnabled.booleanValue()) {
            cacheBuilder.prefetchStrategy((CachedSupplier.PrefetchStrategy)new NonBlocking(asyncThreadName));
        }
        this.sessionCache = cacheBuilder.build();
    }

    private RefreshResult<SessionCredentialsHolder> updateSessionCredentials() {
        SessionCredentialsHolder credentials = new SessionCredentialsHolder(this.getUpdatedCredentials(this.stsClient));
        Instant actualTokenExpiration = credentials.getSessionCredentialsExpiration().toInstant();
        return RefreshResult.builder((Object)credentials).staleTime(actualTokenExpiration.minus(Duration.ofMinutes(1L))).prefetchTime(actualTokenExpiration.minus(Duration.ofMinutes(5L))).build();
    }

    public AwsCredentials getCredentials() {
        return ((SessionCredentialsHolder)this.sessionCache.get()).getSessionCredentials();
    }

    public void close() {
        this.sessionCache.close();
    }

    protected abstract Credentials getUpdatedCredentials(STSClient var1);

    @NotThreadSafe
    protected static abstract class BaseBuilder<B extends BaseBuilder<B, T>, T> {
        private final Function<B, T> providerConstructor;
        private Boolean asyncCredentialUpdateEnabled = false;
        private STSClient stsClient;

        protected BaseBuilder(Function<B, T> providerConstructor) {
            this.providerConstructor = providerConstructor;
        }

        public B stsClient(STSClient stsClient) {
            this.stsClient = stsClient;
            return (B)this;
        }

        public B asyncCredentialUpdateEnabled(Boolean asyncCredentialUpdateEnabled) {
            this.asyncCredentialUpdateEnabled = asyncCredentialUpdateEnabled;
            return (B)this;
        }

        public T build() {
            return this.providerConstructor.apply(this);
        }
    }
}

