/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.w3c.dom.Node;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.AsyncClientHandler;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.SdkAsyncClientHandler;
import software.amazon.awssdk.core.config.AsyncClientConfiguration;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.http.DefaultErrorResponseHandler;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.StaxResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.StandardErrorUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sts.STSAsyncClient;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleResponse;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSAMLRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSAMLResponse;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityResponse;
import software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageRequest;
import software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageResponse;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityRequest;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse;
import software.amazon.awssdk.services.sts.model.GetFederationTokenRequest;
import software.amazon.awssdk.services.sts.model.GetFederationTokenResponse;
import software.amazon.awssdk.services.sts.model.GetSessionTokenRequest;
import software.amazon.awssdk.services.sts.model.GetSessionTokenResponse;
import software.amazon.awssdk.services.sts.model.STSException;
import software.amazon.awssdk.services.sts.transform.AssumeRoleRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.AssumeRoleResponseUnmarshaller;
import software.amazon.awssdk.services.sts.transform.AssumeRoleWithSAMLRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.AssumeRoleWithSAMLResponseUnmarshaller;
import software.amazon.awssdk.services.sts.transform.AssumeRoleWithWebIdentityRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.AssumeRoleWithWebIdentityResponseUnmarshaller;
import software.amazon.awssdk.services.sts.transform.DecodeAuthorizationMessageRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.DecodeAuthorizationMessageResponseUnmarshaller;
import software.amazon.awssdk.services.sts.transform.ExpiredTokenExceptionUnmarshaller;
import software.amazon.awssdk.services.sts.transform.GetCallerIdentityRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.GetCallerIdentityResponseUnmarshaller;
import software.amazon.awssdk.services.sts.transform.GetFederationTokenRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.GetFederationTokenResponseUnmarshaller;
import software.amazon.awssdk.services.sts.transform.GetSessionTokenRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.GetSessionTokenResponseUnmarshaller;
import software.amazon.awssdk.services.sts.transform.IDPCommunicationErrorExceptionUnmarshaller;
import software.amazon.awssdk.services.sts.transform.IDPRejectedClaimExceptionUnmarshaller;
import software.amazon.awssdk.services.sts.transform.InvalidAuthorizationMessageExceptionUnmarshaller;
import software.amazon.awssdk.services.sts.transform.InvalidIdentityTokenExceptionUnmarshaller;
import software.amazon.awssdk.services.sts.transform.MalformedPolicyDocumentExceptionUnmarshaller;
import software.amazon.awssdk.services.sts.transform.PackedPolicyTooLargeExceptionUnmarshaller;
import software.amazon.awssdk.services.sts.transform.RegionDisabledExceptionUnmarshaller;

@SdkInternalApi
final class DefaultSTSAsyncClient
implements STSAsyncClient {
    private final AsyncClientHandler clientHandler;
    private final List<Unmarshaller<SdkServiceException, Node>> exceptionUnmarshallers;

    protected DefaultSTSAsyncClient(AsyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkAsyncClientHandler(clientConfiguration, null);
        this.exceptionUnmarshallers = this.init();
    }

    @Override
    public CompletableFuture<AssumeRoleResponse> assumeRole(AssumeRoleRequest assumeRoleRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new AssumeRoleResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new AssumeRoleRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)assumeRoleRequest));
    }

    @Override
    public CompletableFuture<AssumeRoleWithSAMLResponse> assumeRoleWithSAML(AssumeRoleWithSAMLRequest assumeRoleWithSAMLRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new AssumeRoleWithSAMLResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new AssumeRoleWithSAMLRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)assumeRoleWithSAMLRequest));
    }

    @Override
    public CompletableFuture<AssumeRoleWithWebIdentityResponse> assumeRoleWithWebIdentity(AssumeRoleWithWebIdentityRequest assumeRoleWithWebIdentityRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new AssumeRoleWithWebIdentityResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new AssumeRoleWithWebIdentityRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)assumeRoleWithWebIdentityRequest));
    }

    @Override
    public CompletableFuture<DecodeAuthorizationMessageResponse> decodeAuthorizationMessage(DecodeAuthorizationMessageRequest decodeAuthorizationMessageRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DecodeAuthorizationMessageResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DecodeAuthorizationMessageRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)decodeAuthorizationMessageRequest));
    }

    @Override
    public CompletableFuture<GetCallerIdentityResponse> getCallerIdentity(GetCallerIdentityRequest getCallerIdentityRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetCallerIdentityResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetCallerIdentityRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getCallerIdentityRequest));
    }

    @Override
    public CompletableFuture<GetFederationTokenResponse> getFederationToken(GetFederationTokenRequest getFederationTokenRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetFederationTokenResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetFederationTokenRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getFederationTokenRequest));
    }

    @Override
    public CompletableFuture<GetSessionTokenResponse> getSessionToken(GetSessionTokenRequest getSessionTokenRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetSessionTokenResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetSessionTokenRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getSessionTokenRequest));
    }

    public void close() {
        this.clientHandler.close();
    }

    private List<Unmarshaller<SdkServiceException, Node>> init() {
        ArrayList<Unmarshaller<SdkServiceException, Node>> unmarshallers = new ArrayList<Unmarshaller<SdkServiceException, Node>>();
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new InvalidAuthorizationMessageExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new ExpiredTokenExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new PackedPolicyTooLargeExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new RegionDisabledExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new MalformedPolicyDocumentExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new IDPCommunicationErrorExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new InvalidIdentityTokenExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new IDPRejectedClaimExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new StandardErrorUnmarshaller(STSException.class));
        return unmarshallers;
    }
}

