/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts;

import java.util.function.Consumer;
import software.amazon.awssdk.core.SdkBaseException;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.regions.ServiceMetadata;
import software.amazon.awssdk.services.sts.DefaultSTSClientBuilder;
import software.amazon.awssdk.services.sts.STSClientBuilder;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleResponse;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSAMLRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSAMLResponse;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityResponse;
import software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageRequest;
import software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageResponse;
import software.amazon.awssdk.services.sts.model.ExpiredTokenException;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityRequest;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse;
import software.amazon.awssdk.services.sts.model.GetFederationTokenRequest;
import software.amazon.awssdk.services.sts.model.GetFederationTokenResponse;
import software.amazon.awssdk.services.sts.model.GetSessionTokenRequest;
import software.amazon.awssdk.services.sts.model.GetSessionTokenResponse;
import software.amazon.awssdk.services.sts.model.IDPCommunicationErrorException;
import software.amazon.awssdk.services.sts.model.IDPRejectedClaimException;
import software.amazon.awssdk.services.sts.model.InvalidAuthorizationMessageException;
import software.amazon.awssdk.services.sts.model.InvalidIdentityTokenException;
import software.amazon.awssdk.services.sts.model.MalformedPolicyDocumentException;
import software.amazon.awssdk.services.sts.model.PackedPolicyTooLargeException;
import software.amazon.awssdk.services.sts.model.RegionDisabledException;
import software.amazon.awssdk.services.sts.model.STSException;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public interface STSClient
extends SdkAutoCloseable {
    public static final String SERVICE_NAME = "sts";

    public static STSClient create() {
        return (STSClient)STSClient.builder().build();
    }

    public static STSClientBuilder builder() {
        return new DefaultSTSClientBuilder();
    }

    default public AssumeRoleResponse assumeRole(AssumeRoleRequest assumeRoleRequest) throws MalformedPolicyDocumentException, PackedPolicyTooLargeException, RegionDisabledException, SdkBaseException, SdkClientException, STSException {
        throw new UnsupportedOperationException();
    }

    default public AssumeRoleResponse assumeRole(Consumer<AssumeRoleRequest.Builder> assumeRoleRequest) throws MalformedPolicyDocumentException, PackedPolicyTooLargeException, RegionDisabledException, SdkBaseException, SdkClientException, STSException {
        return this.assumeRole((AssumeRoleRequest)((Object)((AssumeRoleRequest.Builder)AssumeRoleRequest.builder().apply(assumeRoleRequest)).build()));
    }

    default public AssumeRoleWithSAMLResponse assumeRoleWithSAML(AssumeRoleWithSAMLRequest assumeRoleWithSAMLRequest) throws MalformedPolicyDocumentException, PackedPolicyTooLargeException, IDPRejectedClaimException, InvalidIdentityTokenException, ExpiredTokenException, RegionDisabledException, SdkBaseException, SdkClientException, STSException {
        throw new UnsupportedOperationException();
    }

    default public AssumeRoleWithSAMLResponse assumeRoleWithSAML(Consumer<AssumeRoleWithSAMLRequest.Builder> assumeRoleWithSAMLRequest) throws MalformedPolicyDocumentException, PackedPolicyTooLargeException, IDPRejectedClaimException, InvalidIdentityTokenException, ExpiredTokenException, RegionDisabledException, SdkBaseException, SdkClientException, STSException {
        return this.assumeRoleWithSAML((AssumeRoleWithSAMLRequest)((Object)((AssumeRoleWithSAMLRequest.Builder)AssumeRoleWithSAMLRequest.builder().apply(assumeRoleWithSAMLRequest)).build()));
    }

    default public AssumeRoleWithWebIdentityResponse assumeRoleWithWebIdentity(AssumeRoleWithWebIdentityRequest assumeRoleWithWebIdentityRequest) throws MalformedPolicyDocumentException, PackedPolicyTooLargeException, IDPRejectedClaimException, IDPCommunicationErrorException, InvalidIdentityTokenException, ExpiredTokenException, RegionDisabledException, SdkBaseException, SdkClientException, STSException {
        throw new UnsupportedOperationException();
    }

    default public AssumeRoleWithWebIdentityResponse assumeRoleWithWebIdentity(Consumer<AssumeRoleWithWebIdentityRequest.Builder> assumeRoleWithWebIdentityRequest) throws MalformedPolicyDocumentException, PackedPolicyTooLargeException, IDPRejectedClaimException, IDPCommunicationErrorException, InvalidIdentityTokenException, ExpiredTokenException, RegionDisabledException, SdkBaseException, SdkClientException, STSException {
        return this.assumeRoleWithWebIdentity((AssumeRoleWithWebIdentityRequest)((Object)((AssumeRoleWithWebIdentityRequest.Builder)AssumeRoleWithWebIdentityRequest.builder().apply(assumeRoleWithWebIdentityRequest)).build()));
    }

    default public DecodeAuthorizationMessageResponse decodeAuthorizationMessage(DecodeAuthorizationMessageRequest decodeAuthorizationMessageRequest) throws InvalidAuthorizationMessageException, SdkBaseException, SdkClientException, STSException {
        throw new UnsupportedOperationException();
    }

    default public DecodeAuthorizationMessageResponse decodeAuthorizationMessage(Consumer<DecodeAuthorizationMessageRequest.Builder> decodeAuthorizationMessageRequest) throws InvalidAuthorizationMessageException, SdkBaseException, SdkClientException, STSException {
        return this.decodeAuthorizationMessage((DecodeAuthorizationMessageRequest)((Object)((DecodeAuthorizationMessageRequest.Builder)DecodeAuthorizationMessageRequest.builder().apply(decodeAuthorizationMessageRequest)).build()));
    }

    default public GetCallerIdentityResponse getCallerIdentity() throws SdkBaseException, SdkClientException, STSException {
        return this.getCallerIdentity((GetCallerIdentityRequest)((Object)GetCallerIdentityRequest.builder().build()));
    }

    default public GetCallerIdentityResponse getCallerIdentity(GetCallerIdentityRequest getCallerIdentityRequest) throws SdkBaseException, SdkClientException, STSException {
        throw new UnsupportedOperationException();
    }

    default public GetCallerIdentityResponse getCallerIdentity(Consumer<GetCallerIdentityRequest.Builder> getCallerIdentityRequest) throws SdkBaseException, SdkClientException, STSException {
        return this.getCallerIdentity((GetCallerIdentityRequest)((Object)((GetCallerIdentityRequest.Builder)GetCallerIdentityRequest.builder().apply(getCallerIdentityRequest)).build()));
    }

    default public GetFederationTokenResponse getFederationToken(GetFederationTokenRequest getFederationTokenRequest) throws MalformedPolicyDocumentException, PackedPolicyTooLargeException, RegionDisabledException, SdkBaseException, SdkClientException, STSException {
        throw new UnsupportedOperationException();
    }

    default public GetFederationTokenResponse getFederationToken(Consumer<GetFederationTokenRequest.Builder> getFederationTokenRequest) throws MalformedPolicyDocumentException, PackedPolicyTooLargeException, RegionDisabledException, SdkBaseException, SdkClientException, STSException {
        return this.getFederationToken((GetFederationTokenRequest)((Object)((GetFederationTokenRequest.Builder)GetFederationTokenRequest.builder().apply(getFederationTokenRequest)).build()));
    }

    default public GetSessionTokenResponse getSessionToken() throws RegionDisabledException, SdkBaseException, SdkClientException, STSException {
        return this.getSessionToken((GetSessionTokenRequest)((Object)GetSessionTokenRequest.builder().build()));
    }

    default public GetSessionTokenResponse getSessionToken(GetSessionTokenRequest getSessionTokenRequest) throws RegionDisabledException, SdkBaseException, SdkClientException, STSException {
        throw new UnsupportedOperationException();
    }

    default public GetSessionTokenResponse getSessionToken(Consumer<GetSessionTokenRequest.Builder> getSessionTokenRequest) throws RegionDisabledException, SdkBaseException, SdkClientException, STSException {
        return this.getSessionToken((GetSessionTokenRequest)((Object)((GetSessionTokenRequest.Builder)GetSessionTokenRequest.builder().apply(getSessionTokenRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }
}

