/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.sts.model.Credentials;
import software.amazon.awssdk.services.sts.model.FederatedUser;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetFederationTokenResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetFederationTokenResponse> {
    private final Credentials credentials;
    private final FederatedUser federatedUser;
    private final Integer packedPolicySize;

    private GetFederationTokenResponse(BuilderImpl builder) {
        this.credentials = builder.credentials;
        this.federatedUser = builder.federatedUser;
        this.packedPolicySize = builder.packedPolicySize;
    }

    public Credentials credentials() {
        return this.credentials;
    }

    public FederatedUser federatedUser() {
        return this.federatedUser;
    }

    public Integer packedPolicySize() {
        return this.packedPolicySize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.credentials() == null ? 0 : this.credentials().hashCode());
        hashCode = 31 * hashCode + (this.federatedUser() == null ? 0 : this.federatedUser().hashCode());
        hashCode = 31 * hashCode + (this.packedPolicySize() == null ? 0 : this.packedPolicySize().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFederationTokenResponse)) {
            return false;
        }
        GetFederationTokenResponse other = (GetFederationTokenResponse)((Object)obj);
        if (other.credentials() == null ^ this.credentials() == null) {
            return false;
        }
        if (other.credentials() != null && !other.credentials().equals(this.credentials())) {
            return false;
        }
        if (other.federatedUser() == null ^ this.federatedUser() == null) {
            return false;
        }
        if (other.federatedUser() != null && !other.federatedUser().equals(this.federatedUser())) {
            return false;
        }
        if (other.packedPolicySize() == null ^ this.packedPolicySize() == null) {
            return false;
        }
        return other.packedPolicySize() == null || other.packedPolicySize().equals(this.packedPolicySize());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.credentials() != null) {
            sb.append("Credentials: ").append(this.credentials()).append(",");
        }
        if (this.federatedUser() != null) {
            sb.append("FederatedUser: ").append(this.federatedUser()).append(",");
        }
        if (this.packedPolicySize() != null) {
            sb.append("PackedPolicySize: ").append(this.packedPolicySize()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Credentials": {
                return Optional.of(clazz.cast(this.credentials()));
            }
            case "FederatedUser": {
                return Optional.of(clazz.cast(this.federatedUser()));
            }
            case "PackedPolicySize": {
                return Optional.of(clazz.cast(this.packedPolicySize()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Credentials credentials;
        private FederatedUser federatedUser;
        private Integer packedPolicySize;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFederationTokenResponse model) {
            this.credentials(model.credentials);
            this.federatedUser(model.federatedUser);
            this.packedPolicySize(model.packedPolicySize);
        }

        public final Credentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        public final FederatedUser.Builder getFederatedUser() {
            return this.federatedUser != null ? this.federatedUser.toBuilder() : null;
        }

        @Override
        public final Builder federatedUser(FederatedUser federatedUser) {
            this.federatedUser = federatedUser;
            return this;
        }

        public final void setFederatedUser(FederatedUser.BuilderImpl federatedUser) {
            this.federatedUser = federatedUser != null ? federatedUser.build() : null;
        }

        public final Integer getPackedPolicySize() {
            return this.packedPolicySize;
        }

        @Override
        public final Builder packedPolicySize(Integer packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
            return this;
        }

        public final void setPackedPolicySize(Integer packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
        }

        public GetFederationTokenResponse build() {
            return new GetFederationTokenResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetFederationTokenResponse> {
        public Builder credentials(Credentials var1);

        public Builder federatedUser(FederatedUser var1);

        public Builder packedPolicySize(Integer var1);
    }
}

