/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sts.model.GetFederationTokenRequest;

public class GetFederationTokenRequestMarshaller
implements Marshaller<Request<GetFederationTokenRequest>, GetFederationTokenRequest> {
    public Request<GetFederationTokenRequest> marshall(GetFederationTokenRequest getFederationTokenRequest) {
        if (getFederationTokenRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)getFederationTokenRequest, "StsClient");
        request.addParameter("Action", "GetFederationToken");
        request.addParameter("Version", "2011-06-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (getFederationTokenRequest.name() != null) {
            request.addParameter("Name", StringConversion.fromString((String)getFederationTokenRequest.name()));
        }
        if (getFederationTokenRequest.policy() != null) {
            request.addParameter("Policy", StringConversion.fromString((String)getFederationTokenRequest.policy()));
        }
        if (getFederationTokenRequest.durationSeconds() != null) {
            request.addParameter("DurationSeconds", StringConversion.fromInteger((Integer)getFederationTokenRequest.durationSeconds()));
        }
        return request;
    }
}

