/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.auth;

import software.amazon.awssdk.annotation.NotThreadSafe;
import software.amazon.awssdk.annotation.ThreadSafe;
import software.amazon.awssdk.services.sts.STSClient;
import software.amazon.awssdk.services.sts.auth.StsCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.Credentials;
import software.amazon.awssdk.utils.Validate;

@ThreadSafe
public class StsAssumeRoleCredentialsProvider
extends StsCredentialsProvider {
    private final AssumeRoleRequest assumeRoleRequest;

    private StsAssumeRoleCredentialsProvider(Builder builder) {
        super(builder, "sts-assume-role-credentials-provider");
        Validate.notNull((Object)((Object)builder.assumeRoleRequest), (String)"Assume role request must not be null.", (Object[])new Object[0]);
        this.assumeRoleRequest = builder.assumeRoleRequest;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected Credentials getUpdatedCredentials(STSClient stsClient) {
        return stsClient.assumeRole(this.assumeRoleRequest).credentials();
    }

    @NotThreadSafe
    public static final class Builder
    extends StsCredentialsProvider.BaseBuilder<Builder, StsAssumeRoleCredentialsProvider> {
        private AssumeRoleRequest assumeRoleRequest;

        private Builder() {
            super((B x$0) -> new StsAssumeRoleCredentialsProvider((Builder)x$0));
        }

        public Builder refreshRequest(AssumeRoleRequest assumeRoleRequest) {
            this.assumeRoleRequest = assumeRoleRequest;
            return this;
        }
    }
}

