/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.storagegateway.StorageGatewayClient;
import software.amazon.awssdk.services.storagegateway.internal.UserAgentUtils;
import software.amazon.awssdk.services.storagegateway.model.CacheReportInfo;
import software.amazon.awssdk.services.storagegateway.model.ListCacheReportsRequest;
import software.amazon.awssdk.services.storagegateway.model.ListCacheReportsResponse;

public class ListCacheReportsIterable
implements SdkIterable<ListCacheReportsResponse> {
    private final StorageGatewayClient client;
    private final ListCacheReportsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCacheReportsIterable(StorageGatewayClient client, ListCacheReportsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCacheReportsResponseFetcher();
    }

    public Iterator<ListCacheReportsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CacheReportInfo> cacheReportList() {
        Function<ListCacheReportsResponse, Iterator> getIterator = response -> {
            if (response != null && response.cacheReportList() != null) {
                return response.cacheReportList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCacheReportsResponseFetcher
    implements SyncPageFetcher<ListCacheReportsResponse> {
        private ListCacheReportsResponseFetcher() {
        }

        public boolean hasNextPage(ListCacheReportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public ListCacheReportsResponse nextPage(ListCacheReportsResponse previousPage) {
            if (previousPage == null) {
                return ListCacheReportsIterable.this.client.listCacheReports(ListCacheReportsIterable.this.firstRequest);
            }
            return ListCacheReportsIterable.this.client.listCacheReports((ListCacheReportsRequest)((Object)ListCacheReportsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

