/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.storagegateway.model.SMBLocalGroups;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSmbLocalGroupsRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, UpdateSmbLocalGroupsRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayARN").getter(UpdateSmbLocalGroupsRequest.getter(UpdateSmbLocalGroupsRequest::gatewayARN)).setter(UpdateSmbLocalGroupsRequest.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<SMBLocalGroups> SMB_LOCAL_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SMBLocalGroups").getter(UpdateSmbLocalGroupsRequest.getter(UpdateSmbLocalGroupsRequest::smbLocalGroups)).setter(UpdateSmbLocalGroupsRequest.setter(Builder::smbLocalGroups)).constructor(SMBLocalGroups::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMBLocalGroups").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, SMB_LOCAL_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("GatewayARN", GATEWAY_ARN_FIELD);
            this.put("SMBLocalGroups", SMB_LOCAL_GROUPS_FIELD);
        }
    });
    private final String gatewayARN;
    private final SMBLocalGroups smbLocalGroups;

    private UpdateSmbLocalGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.smbLocalGroups = builder.smbLocalGroups;
    }

    public final String gatewayARN() {
        return this.gatewayARN;
    }

    public final SMBLocalGroups smbLocalGroups() {
        return this.smbLocalGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.smbLocalGroups());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSmbLocalGroupsRequest)) {
            return false;
        }
        UpdateSmbLocalGroupsRequest other = (UpdateSmbLocalGroupsRequest)((Object)obj);
        return Objects.equals(this.gatewayARN(), other.gatewayARN()) && Objects.equals(this.smbLocalGroups(), other.smbLocalGroups());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSmbLocalGroupsRequest").add("GatewayARN", (Object)this.gatewayARN()).add("SMBLocalGroups", (Object)this.smbLocalGroups()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "SMBLocalGroups": {
                return Optional.ofNullable(clazz.cast(this.smbLocalGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSmbLocalGroupsRequest, T> g) {
        return obj -> g.apply((UpdateSmbLocalGroupsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private String gatewayARN;
        private SMBLocalGroups smbLocalGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSmbLocalGroupsRequest model) {
            super(model);
            this.gatewayARN(model.gatewayARN);
            this.smbLocalGroups(model.smbLocalGroups);
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final SMBLocalGroups.Builder getSmbLocalGroups() {
            return this.smbLocalGroups != null ? this.smbLocalGroups.toBuilder() : null;
        }

        public final void setSmbLocalGroups(SMBLocalGroups.BuilderImpl smbLocalGroups) {
            this.smbLocalGroups = smbLocalGroups != null ? smbLocalGroups.build() : null;
        }

        @Override
        public final Builder smbLocalGroups(SMBLocalGroups smbLocalGroups) {
            this.smbLocalGroups = smbLocalGroups;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSmbLocalGroupsRequest build() {
            return new UpdateSmbLocalGroupsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSmbLocalGroupsRequest> {
        public Builder gatewayARN(String var1);

        public Builder smbLocalGroups(SMBLocalGroups var1);

        default public Builder smbLocalGroups(Consumer<SMBLocalGroups.Builder> smbLocalGroups) {
            return this.smbLocalGroups((SMBLocalGroups)((SMBLocalGroups.Builder)SMBLocalGroups.builder().applyMutation(smbLocalGroups)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

