/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.AutomaticTapeCreationRule;
import software.amazon.awssdk.services.storagegateway.model.AutomaticTapeCreationRulesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomaticTapeCreationPolicyInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomaticTapeCreationPolicyInfo> {
    private static final SdkField<List<AutomaticTapeCreationRule>> AUTOMATIC_TAPE_CREATION_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AutomaticTapeCreationRules").getter(AutomaticTapeCreationPolicyInfo.getter(AutomaticTapeCreationPolicyInfo::automaticTapeCreationRules)).setter(AutomaticTapeCreationPolicyInfo.setter(Builder::automaticTapeCreationRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticTapeCreationRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomaticTapeCreationRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayARN").getter(AutomaticTapeCreationPolicyInfo.getter(AutomaticTapeCreationPolicyInfo::gatewayARN)).setter(AutomaticTapeCreationPolicyInfo.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATIC_TAPE_CREATION_RULES_FIELD, GATEWAY_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<AutomaticTapeCreationRule> automaticTapeCreationRules;
    private final String gatewayARN;

    private AutomaticTapeCreationPolicyInfo(BuilderImpl builder) {
        this.automaticTapeCreationRules = builder.automaticTapeCreationRules;
        this.gatewayARN = builder.gatewayARN;
    }

    public final boolean hasAutomaticTapeCreationRules() {
        return this.automaticTapeCreationRules != null && !(this.automaticTapeCreationRules instanceof SdkAutoConstructList);
    }

    public final List<AutomaticTapeCreationRule> automaticTapeCreationRules() {
        return this.automaticTapeCreationRules;
    }

    public final String gatewayARN() {
        return this.gatewayARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutomaticTapeCreationRules() ? this.automaticTapeCreationRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomaticTapeCreationPolicyInfo)) {
            return false;
        }
        AutomaticTapeCreationPolicyInfo other = (AutomaticTapeCreationPolicyInfo)obj;
        return this.hasAutomaticTapeCreationRules() == other.hasAutomaticTapeCreationRules() && Objects.equals(this.automaticTapeCreationRules(), other.automaticTapeCreationRules()) && Objects.equals(this.gatewayARN(), other.gatewayARN());
    }

    public final String toString() {
        return ToString.builder((String)"AutomaticTapeCreationPolicyInfo").add("AutomaticTapeCreationRules", this.hasAutomaticTapeCreationRules() ? this.automaticTapeCreationRules() : null).add("GatewayARN", (Object)this.gatewayARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutomaticTapeCreationRules": {
                return Optional.ofNullable(clazz.cast(this.automaticTapeCreationRules()));
            }
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutomaticTapeCreationPolicyInfo, T> g) {
        return obj -> g.apply((AutomaticTapeCreationPolicyInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AutomaticTapeCreationRule> automaticTapeCreationRules = DefaultSdkAutoConstructList.getInstance();
        private String gatewayARN;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomaticTapeCreationPolicyInfo model) {
            this.automaticTapeCreationRules(model.automaticTapeCreationRules);
            this.gatewayARN(model.gatewayARN);
        }

        public final Collection<AutomaticTapeCreationRule.Builder> getAutomaticTapeCreationRules() {
            if (this.automaticTapeCreationRules instanceof SdkAutoConstructList) {
                return null;
            }
            return this.automaticTapeCreationRules != null ? (Collection)this.automaticTapeCreationRules.stream().map(AutomaticTapeCreationRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder automaticTapeCreationRules(Collection<AutomaticTapeCreationRule> automaticTapeCreationRules) {
            this.automaticTapeCreationRules = AutomaticTapeCreationRulesCopier.copy(automaticTapeCreationRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automaticTapeCreationRules(AutomaticTapeCreationRule ... automaticTapeCreationRules) {
            this.automaticTapeCreationRules(Arrays.asList(automaticTapeCreationRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automaticTapeCreationRules(Consumer<AutomaticTapeCreationRule.Builder> ... automaticTapeCreationRules) {
            this.automaticTapeCreationRules(Stream.of(automaticTapeCreationRules).map(c -> (AutomaticTapeCreationRule)((AutomaticTapeCreationRule.Builder)AutomaticTapeCreationRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAutomaticTapeCreationRules(Collection<AutomaticTapeCreationRule.BuilderImpl> automaticTapeCreationRules) {
            this.automaticTapeCreationRules = AutomaticTapeCreationRulesCopier.copyFromBuilder(automaticTapeCreationRules);
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public AutomaticTapeCreationPolicyInfo build() {
            return new AutomaticTapeCreationPolicyInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomaticTapeCreationPolicyInfo> {
        public Builder automaticTapeCreationRules(Collection<AutomaticTapeCreationRule> var1);

        public Builder automaticTapeCreationRules(AutomaticTapeCreationRule ... var1);

        public Builder automaticTapeCreationRules(Consumer<AutomaticTapeCreationRule.Builder> ... var1);

        public Builder gatewayARN(String var1);
    }
}

