/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a virtual tape.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TapeInfo implements SdkPojo, Serializable, ToCopyableBuilder<TapeInfo.Builder, TapeInfo> {
    private static final SdkField<String> TAPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TapeARN").getter(getter(TapeInfo::tapeARN)).setter(setter(Builder::tapeARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeARN").build()).build();

    private static final SdkField<String> TAPE_BARCODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TapeBarcode").getter(getter(TapeInfo::tapeBarcode)).setter(setter(Builder::tapeBarcode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeBarcode").build()).build();

    private static final SdkField<Long> TAPE_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TapeSizeInBytes").getter(getter(TapeInfo::tapeSizeInBytes)).setter(setter(Builder::tapeSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeSizeInBytes").build()).build();

    private static final SdkField<String> TAPE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TapeStatus").getter(getter(TapeInfo::tapeStatus)).setter(setter(Builder::tapeStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeStatus").build()).build();

    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(TapeInfo::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<String> POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PoolId")
            .getter(getter(TapeInfo::poolId)).setter(setter(Builder::poolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()).build();

    private static final SdkField<Instant> RETENTION_START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RetentionStartDate").getter(getter(TapeInfo::retentionStartDate))
            .setter(setter(Builder::retentionStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionStartDate").build())
            .build();

    private static final SdkField<Instant> POOL_ENTRY_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("PoolEntryDate").getter(getter(TapeInfo::poolEntryDate)).setter(setter(Builder::poolEntryDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolEntryDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAPE_ARN_FIELD,
            TAPE_BARCODE_FIELD, TAPE_SIZE_IN_BYTES_FIELD, TAPE_STATUS_FIELD, GATEWAY_ARN_FIELD, POOL_ID_FIELD,
            RETENTION_START_DATE_FIELD, POOL_ENTRY_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tapeARN;

    private final String tapeBarcode;

    private final Long tapeSizeInBytes;

    private final String tapeStatus;

    private final String gatewayARN;

    private final String poolId;

    private final Instant retentionStartDate;

    private final Instant poolEntryDate;

    private TapeInfo(BuilderImpl builder) {
        this.tapeARN = builder.tapeARN;
        this.tapeBarcode = builder.tapeBarcode;
        this.tapeSizeInBytes = builder.tapeSizeInBytes;
        this.tapeStatus = builder.tapeStatus;
        this.gatewayARN = builder.gatewayARN;
        this.poolId = builder.poolId;
        this.retentionStartDate = builder.retentionStartDate;
        this.poolEntryDate = builder.poolEntryDate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a virtual tape.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a virtual tape.
     */
    public final String tapeARN() {
        return tapeARN;
    }

    /**
     * <p>
     * The barcode that identifies a specific virtual tape.
     * </p>
     * 
     * @return The barcode that identifies a specific virtual tape.
     */
    public final String tapeBarcode() {
        return tapeBarcode;
    }

    /**
     * <p>
     * The size, in bytes, of a virtual tape.
     * </p>
     * 
     * @return The size, in bytes, of a virtual tape.
     */
    public final Long tapeSizeInBytes() {
        return tapeSizeInBytes;
    }

    /**
     * <p>
     * The status of the tape.
     * </p>
     * 
     * @return The status of the tape.
     */
    public final String tapeStatus() {
        return tapeStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a> operation to return a list of gateways
     * for your account and AWS Region.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a> operation to return a list of
     *         gateways for your account and AWS Region.
     */
    public final String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the S3
     * storage class that is associated with the pool. When you use your backup application to eject the tape, the tape
     * is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
     * </p>
     * <p>
     * Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
     * </p>
     * 
     * @return The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in
     *         the S3 storage class that is associated with the pool. When you use your backup application to eject the
     *         tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that
     *         corresponds to the pool.</p>
     *         <p>
     *         Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
     */
    public final String poolId() {
        return poolId;
    }

    /**
     * <p>
     * The date that the tape became subject to tape retention lock.
     * </p>
     * 
     * @return The date that the tape became subject to tape retention lock.
     */
    public final Instant retentionStartDate() {
        return retentionStartDate;
    }

    /**
     * <p>
     * The date that the tape entered the custom tape pool with tape retention lock enabled.
     * </p>
     * 
     * @return The date that the tape entered the custom tape pool with tape retention lock enabled.
     */
    public final Instant poolEntryDate() {
        return poolEntryDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tapeARN());
        hashCode = 31 * hashCode + Objects.hashCode(tapeBarcode());
        hashCode = 31 * hashCode + Objects.hashCode(tapeSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(tapeStatus());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(poolId());
        hashCode = 31 * hashCode + Objects.hashCode(retentionStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(poolEntryDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TapeInfo)) {
            return false;
        }
        TapeInfo other = (TapeInfo) obj;
        return Objects.equals(tapeARN(), other.tapeARN()) && Objects.equals(tapeBarcode(), other.tapeBarcode())
                && Objects.equals(tapeSizeInBytes(), other.tapeSizeInBytes()) && Objects.equals(tapeStatus(), other.tapeStatus())
                && Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(poolId(), other.poolId())
                && Objects.equals(retentionStartDate(), other.retentionStartDate())
                && Objects.equals(poolEntryDate(), other.poolEntryDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TapeInfo").add("TapeARN", tapeARN()).add("TapeBarcode", tapeBarcode())
                .add("TapeSizeInBytes", tapeSizeInBytes()).add("TapeStatus", tapeStatus()).add("GatewayARN", gatewayARN())
                .add("PoolId", poolId()).add("RetentionStartDate", retentionStartDate()).add("PoolEntryDate", poolEntryDate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TapeARN":
            return Optional.ofNullable(clazz.cast(tapeARN()));
        case "TapeBarcode":
            return Optional.ofNullable(clazz.cast(tapeBarcode()));
        case "TapeSizeInBytes":
            return Optional.ofNullable(clazz.cast(tapeSizeInBytes()));
        case "TapeStatus":
            return Optional.ofNullable(clazz.cast(tapeStatus()));
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "PoolId":
            return Optional.ofNullable(clazz.cast(poolId()));
        case "RetentionStartDate":
            return Optional.ofNullable(clazz.cast(retentionStartDate()));
        case "PoolEntryDate":
            return Optional.ofNullable(clazz.cast(poolEntryDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TapeInfo, T> g) {
        return obj -> g.apply((TapeInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TapeInfo> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of a virtual tape.
         * </p>
         * 
         * @param tapeARN
         *        The Amazon Resource Name (ARN) of a virtual tape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeARN(String tapeARN);

        /**
         * <p>
         * The barcode that identifies a specific virtual tape.
         * </p>
         * 
         * @param tapeBarcode
         *        The barcode that identifies a specific virtual tape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeBarcode(String tapeBarcode);

        /**
         * <p>
         * The size, in bytes, of a virtual tape.
         * </p>
         * 
         * @param tapeSizeInBytes
         *        The size, in bytes, of a virtual tape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeSizeInBytes(Long tapeSizeInBytes);

        /**
         * <p>
         * The status of the tape.
         * </p>
         * 
         * @param tapeStatus
         *        The status of the tape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeStatus(String tapeStatus);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a> operation to return a list of
         * gateways for your account and AWS Region.
         * </p>
         * 
         * @param gatewayARN
         *        The Amazon Resource Name (ARN) of the gateway. Use the <a>ListGateways</a> operation to return a list
         *        of gateways for your account and AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the
         * S3 storage class that is associated with the pool. When you use your backup application to eject the tape,
         * the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds
         * to the pool.
         * </p>
         * <p>
         * Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
         * </p>
         * 
         * @param poolId
         *        The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived
         *        in the S3 storage class that is associated with the pool. When you use your backup application to
         *        eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep
         *        Archive) that corresponds to the pool.</p>
         *        <p>
         *        Valid Values: <code>GLACIER</code> | <code>DEEP_ARCHIVE</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolId(String poolId);

        /**
         * <p>
         * The date that the tape became subject to tape retention lock.
         * </p>
         * 
         * @param retentionStartDate
         *        The date that the tape became subject to tape retention lock.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionStartDate(Instant retentionStartDate);

        /**
         * <p>
         * The date that the tape entered the custom tape pool with tape retention lock enabled.
         * </p>
         * 
         * @param poolEntryDate
         *        The date that the tape entered the custom tape pool with tape retention lock enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolEntryDate(Instant poolEntryDate);
    }

    static final class BuilderImpl implements Builder {
        private String tapeARN;

        private String tapeBarcode;

        private Long tapeSizeInBytes;

        private String tapeStatus;

        private String gatewayARN;

        private String poolId;

        private Instant retentionStartDate;

        private Instant poolEntryDate;

        private BuilderImpl() {
        }

        private BuilderImpl(TapeInfo model) {
            tapeARN(model.tapeARN);
            tapeBarcode(model.tapeBarcode);
            tapeSizeInBytes(model.tapeSizeInBytes);
            tapeStatus(model.tapeStatus);
            gatewayARN(model.gatewayARN);
            poolId(model.poolId);
            retentionStartDate(model.retentionStartDate);
            poolEntryDate(model.poolEntryDate);
        }

        public final String getTapeARN() {
            return tapeARN;
        }

        @Override
        public final Builder tapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
            return this;
        }

        public final void setTapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
        }

        public final String getTapeBarcode() {
            return tapeBarcode;
        }

        @Override
        public final Builder tapeBarcode(String tapeBarcode) {
            this.tapeBarcode = tapeBarcode;
            return this;
        }

        public final void setTapeBarcode(String tapeBarcode) {
            this.tapeBarcode = tapeBarcode;
        }

        public final Long getTapeSizeInBytes() {
            return tapeSizeInBytes;
        }

        @Override
        public final Builder tapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
            return this;
        }

        public final void setTapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
        }

        public final String getTapeStatus() {
            return tapeStatus;
        }

        @Override
        public final Builder tapeStatus(String tapeStatus) {
            this.tapeStatus = tapeStatus;
            return this;
        }

        public final void setTapeStatus(String tapeStatus) {
            this.tapeStatus = tapeStatus;
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final String getPoolId() {
            return poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        public final Instant getRetentionStartDate() {
            return retentionStartDate;
        }

        @Override
        public final Builder retentionStartDate(Instant retentionStartDate) {
            this.retentionStartDate = retentionStartDate;
            return this;
        }

        public final void setRetentionStartDate(Instant retentionStartDate) {
            this.retentionStartDate = retentionStartDate;
        }

        public final Instant getPoolEntryDate() {
            return poolEntryDate;
        }

        @Override
        public final Builder poolEntryDate(Instant poolEntryDate) {
            this.poolEntryDate = poolEntryDate;
            return this;
        }

        public final void setPoolEntryDate(Instant poolEntryDate) {
            this.poolEntryDate = poolEntryDate;
        }

        @Override
        public TapeInfo build() {
            return new TapeInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
