/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GatewayInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GatewayInfo> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GatewayInfo.getter(GatewayInfo::gatewayId)).setter(GatewayInfo.setter(Builder::gatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId").build()}).build();
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GatewayInfo.getter(GatewayInfo::gatewayARN)).setter(GatewayInfo.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<String> GATEWAY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GatewayInfo.getter(GatewayInfo::gatewayType)).setter(GatewayInfo.setter(Builder::gatewayType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayType").build()}).build();
    private static final SdkField<String> GATEWAY_OPERATIONAL_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GatewayInfo.getter(GatewayInfo::gatewayOperationalState)).setter(GatewayInfo.setter(Builder::gatewayOperationalState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayOperationalState").build()}).build();
    private static final SdkField<String> GATEWAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GatewayInfo.getter(GatewayInfo::gatewayName)).setter(GatewayInfo.setter(Builder::gatewayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayName").build()}).build();
    private static final SdkField<String> EC2_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GatewayInfo.getter(GatewayInfo::ec2InstanceId)).setter(GatewayInfo.setter(Builder::ec2InstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2InstanceId").build()}).build();
    private static final SdkField<String> EC2_INSTANCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GatewayInfo.getter(GatewayInfo::ec2InstanceRegion)).setter(GatewayInfo.setter(Builder::ec2InstanceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2InstanceRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD, GATEWAY_ARN_FIELD, GATEWAY_TYPE_FIELD, GATEWAY_OPERATIONAL_STATE_FIELD, GATEWAY_NAME_FIELD, EC2_INSTANCE_ID_FIELD, EC2_INSTANCE_REGION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String gatewayId;
    private final String gatewayARN;
    private final String gatewayType;
    private final String gatewayOperationalState;
    private final String gatewayName;
    private final String ec2InstanceId;
    private final String ec2InstanceRegion;

    private GatewayInfo(BuilderImpl builder) {
        this.gatewayId = builder.gatewayId;
        this.gatewayARN = builder.gatewayARN;
        this.gatewayType = builder.gatewayType;
        this.gatewayOperationalState = builder.gatewayOperationalState;
        this.gatewayName = builder.gatewayName;
        this.ec2InstanceId = builder.ec2InstanceId;
        this.ec2InstanceRegion = builder.ec2InstanceRegion;
    }

    public String gatewayId() {
        return this.gatewayId;
    }

    public String gatewayARN() {
        return this.gatewayARN;
    }

    public String gatewayType() {
        return this.gatewayType;
    }

    public String gatewayOperationalState() {
        return this.gatewayOperationalState;
    }

    public String gatewayName() {
        return this.gatewayName;
    }

    public String ec2InstanceId() {
        return this.ec2InstanceId;
    }

    public String ec2InstanceRegion() {
        return this.ec2InstanceRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayType());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayOperationalState());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceRegion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GatewayInfo)) {
            return false;
        }
        GatewayInfo other = (GatewayInfo)obj;
        return Objects.equals(this.gatewayId(), other.gatewayId()) && Objects.equals(this.gatewayARN(), other.gatewayARN()) && Objects.equals(this.gatewayType(), other.gatewayType()) && Objects.equals(this.gatewayOperationalState(), other.gatewayOperationalState()) && Objects.equals(this.gatewayName(), other.gatewayName()) && Objects.equals(this.ec2InstanceId(), other.ec2InstanceId()) && Objects.equals(this.ec2InstanceRegion(), other.ec2InstanceRegion());
    }

    public String toString() {
        return ToString.builder((String)"GatewayInfo").add("GatewayId", (Object)this.gatewayId()).add("GatewayARN", (Object)this.gatewayARN()).add("GatewayType", (Object)this.gatewayType()).add("GatewayOperationalState", (Object)this.gatewayOperationalState()).add("GatewayName", (Object)this.gatewayName()).add("Ec2InstanceId", (Object)this.ec2InstanceId()).add("Ec2InstanceRegion", (Object)this.ec2InstanceRegion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayId": {
                return Optional.ofNullable(clazz.cast(this.gatewayId()));
            }
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "GatewayType": {
                return Optional.ofNullable(clazz.cast(this.gatewayType()));
            }
            case "GatewayOperationalState": {
                return Optional.ofNullable(clazz.cast(this.gatewayOperationalState()));
            }
            case "GatewayName": {
                return Optional.ofNullable(clazz.cast(this.gatewayName()));
            }
            case "Ec2InstanceId": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceId()));
            }
            case "Ec2InstanceRegion": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceRegion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GatewayInfo, T> g) {
        return obj -> g.apply((GatewayInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String gatewayId;
        private String gatewayARN;
        private String gatewayType;
        private String gatewayOperationalState;
        private String gatewayName;
        private String ec2InstanceId;
        private String ec2InstanceRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(GatewayInfo model) {
            this.gatewayId(model.gatewayId);
            this.gatewayARN(model.gatewayARN);
            this.gatewayType(model.gatewayType);
            this.gatewayOperationalState(model.gatewayOperationalState);
            this.gatewayName(model.gatewayName);
            this.ec2InstanceId(model.ec2InstanceId);
            this.ec2InstanceRegion(model.ec2InstanceRegion);
        }

        public final String getGatewayId() {
            return this.gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final String getGatewayType() {
            return this.gatewayType;
        }

        @Override
        public final Builder gatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
            return this;
        }

        public final void setGatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
        }

        public final String getGatewayOperationalState() {
            return this.gatewayOperationalState;
        }

        @Override
        public final Builder gatewayOperationalState(String gatewayOperationalState) {
            this.gatewayOperationalState = gatewayOperationalState;
            return this;
        }

        public final void setGatewayOperationalState(String gatewayOperationalState) {
            this.gatewayOperationalState = gatewayOperationalState;
        }

        public final String getGatewayName() {
            return this.gatewayName;
        }

        @Override
        public final Builder gatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
            return this;
        }

        public final void setGatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
        }

        public final String getEc2InstanceId() {
            return this.ec2InstanceId;
        }

        @Override
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public final void setEc2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        public final String getEc2InstanceRegion() {
            return this.ec2InstanceRegion;
        }

        @Override
        public final Builder ec2InstanceRegion(String ec2InstanceRegion) {
            this.ec2InstanceRegion = ec2InstanceRegion;
            return this;
        }

        public final void setEc2InstanceRegion(String ec2InstanceRegion) {
            this.ec2InstanceRegion = ec2InstanceRegion;
        }

        public GatewayInfo build() {
            return new GatewayInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GatewayInfo> {
        public Builder gatewayId(String var1);

        public Builder gatewayARN(String var1);

        public Builder gatewayType(String var1);

        public Builder gatewayOperationalState(String var1);

        public Builder gatewayName(String var1);

        public Builder ec2InstanceId(String var1);

        public Builder ec2InstanceRegion(String var1);
    }
}

