/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStorediScsiVolumeResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, CreateStorediScsiVolumeResponse> {
    private static final SdkField<String> VOLUME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateStorediScsiVolumeResponse.getter(CreateStorediScsiVolumeResponse::volumeARN)).setter(CreateStorediScsiVolumeResponse.setter(Builder::volumeARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeARN").build()}).build();
    private static final SdkField<Long> VOLUME_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(CreateStorediScsiVolumeResponse.getter(CreateStorediScsiVolumeResponse::volumeSizeInBytes)).setter(CreateStorediScsiVolumeResponse.setter(Builder::volumeSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSizeInBytes").build()}).build();
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateStorediScsiVolumeResponse.getter(CreateStorediScsiVolumeResponse::targetARN)).setter(CreateStorediScsiVolumeResponse.setter(Builder::targetARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ARN_FIELD, VOLUME_SIZE_IN_BYTES_FIELD, TARGET_ARN_FIELD));
    private final String volumeARN;
    private final Long volumeSizeInBytes;
    private final String targetARN;

    private CreateStorediScsiVolumeResponse(BuilderImpl builder) {
        super(builder);
        this.volumeARN = builder.volumeARN;
        this.volumeSizeInBytes = builder.volumeSizeInBytes;
        this.targetARN = builder.targetARN;
    }

    public String volumeARN() {
        return this.volumeARN;
    }

    public Long volumeSizeInBytes() {
        return this.volumeSizeInBytes;
    }

    public String targetARN() {
        return this.targetARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStorediScsiVolumeResponse)) {
            return false;
        }
        CreateStorediScsiVolumeResponse other = (CreateStorediScsiVolumeResponse)((Object)obj);
        return Objects.equals(this.volumeARN(), other.volumeARN()) && Objects.equals(this.volumeSizeInBytes(), other.volumeSizeInBytes()) && Objects.equals(this.targetARN(), other.targetARN());
    }

    public String toString() {
        return ToString.builder((String)"CreateStorediScsiVolumeResponse").add("VolumeARN", (Object)this.volumeARN()).add("VolumeSizeInBytes", (Object)this.volumeSizeInBytes()).add("TargetARN", (Object)this.targetARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumeARN": {
                return Optional.ofNullable(clazz.cast(this.volumeARN()));
            }
            case "VolumeSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.volumeSizeInBytes()));
            }
            case "TargetARN": {
                return Optional.ofNullable(clazz.cast(this.targetARN()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStorediScsiVolumeResponse, T> g) {
        return obj -> g.apply((CreateStorediScsiVolumeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private String volumeARN;
        private Long volumeSizeInBytes;
        private String targetARN;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStorediScsiVolumeResponse model) {
            super(model);
            this.volumeARN(model.volumeARN);
            this.volumeSizeInBytes(model.volumeSizeInBytes);
            this.targetARN(model.targetARN);
        }

        public final String getVolumeARN() {
            return this.volumeARN;
        }

        @Override
        public final Builder volumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
            return this;
        }

        public final void setVolumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
        }

        public final Long getVolumeSizeInBytes() {
            return this.volumeSizeInBytes;
        }

        @Override
        public final Builder volumeSizeInBytes(Long volumeSizeInBytes) {
            this.volumeSizeInBytes = volumeSizeInBytes;
            return this;
        }

        public final void setVolumeSizeInBytes(Long volumeSizeInBytes) {
            this.volumeSizeInBytes = volumeSizeInBytes;
        }

        public final String getTargetARN() {
            return this.targetARN;
        }

        @Override
        public final Builder targetARN(String targetARN) {
            this.targetARN = targetARN;
            return this;
        }

        public final void setTargetARN(String targetARN) {
            this.targetARN = targetARN;
        }

        @Override
        public CreateStorediScsiVolumeResponse build() {
            return new CreateStorediScsiVolumeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStorediScsiVolumeResponse> {
        public Builder volumeARN(String var1);

        public Builder volumeSizeInBytes(Long var1);

        public Builder targetARN(String var1);
    }
}

