/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a virtual tape object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Tape implements SdkPojo, Serializable, ToCopyableBuilder<Tape.Builder, Tape> {
    private static final SdkField<String> TAPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Tape::tapeARN)).setter(setter(Builder::tapeARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeARN").build()).build();

    private static final SdkField<String> TAPE_BARCODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Tape::tapeBarcode)).setter(setter(Builder::tapeBarcode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeBarcode").build()).build();

    private static final SdkField<Instant> TAPE_CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Tape::tapeCreatedDate)).setter(setter(Builder::tapeCreatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeCreatedDate").build()).build();

    private static final SdkField<Long> TAPE_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(Tape::tapeSizeInBytes)).setter(setter(Builder::tapeSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeSizeInBytes").build()).build();

    private static final SdkField<String> TAPE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Tape::tapeStatus)).setter(setter(Builder::tapeStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeStatus").build()).build();

    private static final SdkField<String> VTL_DEVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Tape::vtlDevice)).setter(setter(Builder::vtlDevice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VTLDevice").build()).build();

    private static final SdkField<Double> PROGRESS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Tape::progress)).setter(setter(Builder::progress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress").build()).build();

    private static final SdkField<Long> TAPE_USED_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(Tape::tapeUsedInBytes)).setter(setter(Builder::tapeUsedInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeUsedInBytes").build()).build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Tape::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKey").build()).build();

    private static final SdkField<String> POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Tape::poolId)).setter(setter(Builder::poolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAPE_ARN_FIELD,
            TAPE_BARCODE_FIELD, TAPE_CREATED_DATE_FIELD, TAPE_SIZE_IN_BYTES_FIELD, TAPE_STATUS_FIELD, VTL_DEVICE_FIELD,
            PROGRESS_FIELD, TAPE_USED_IN_BYTES_FIELD, KMS_KEY_FIELD, POOL_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tapeARN;

    private final String tapeBarcode;

    private final Instant tapeCreatedDate;

    private final Long tapeSizeInBytes;

    private final String tapeStatus;

    private final String vtlDevice;

    private final Double progress;

    private final Long tapeUsedInBytes;

    private final String kmsKey;

    private final String poolId;

    private Tape(BuilderImpl builder) {
        this.tapeARN = builder.tapeARN;
        this.tapeBarcode = builder.tapeBarcode;
        this.tapeCreatedDate = builder.tapeCreatedDate;
        this.tapeSizeInBytes = builder.tapeSizeInBytes;
        this.tapeStatus = builder.tapeStatus;
        this.vtlDevice = builder.vtlDevice;
        this.progress = builder.progress;
        this.tapeUsedInBytes = builder.tapeUsedInBytes;
        this.kmsKey = builder.kmsKey;
        this.poolId = builder.poolId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the virtual tape.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the virtual tape.
     */
    public String tapeARN() {
        return tapeARN;
    }

    /**
     * <p>
     * The barcode that identifies a specific virtual tape.
     * </p>
     * 
     * @return The barcode that identifies a specific virtual tape.
     */
    public String tapeBarcode() {
        return tapeBarcode;
    }

    /**
     * <p>
     * The date the virtual tape was created.
     * </p>
     * 
     * @return The date the virtual tape was created.
     */
    public Instant tapeCreatedDate() {
        return tapeCreatedDate;
    }

    /**
     * <p>
     * The size, in bytes, of the virtual tape capacity.
     * </p>
     * 
     * @return The size, in bytes, of the virtual tape capacity.
     */
    public Long tapeSizeInBytes() {
        return tapeSizeInBytes;
    }

    /**
     * <p>
     * The current state of the virtual tape.
     * </p>
     * 
     * @return The current state of the virtual tape.
     */
    public String tapeStatus() {
        return tapeStatus;
    }

    /**
     * <p>
     * The virtual tape library (VTL) device that the virtual tape is associated with.
     * </p>
     * 
     * @return The virtual tape library (VTL) device that the virtual tape is associated with.
     */
    public String vtlDevice() {
        return vtlDevice;
    }

    /**
     * <p>
     * For archiving virtual tapes, indicates how much data remains to be uploaded before archiving is complete.
     * </p>
     * <p>
     * Range: 0 (not started) to 100 (complete).
     * </p>
     * 
     * @return For archiving virtual tapes, indicates how much data remains to be uploaded before archiving is
     *         complete.</p>
     *         <p>
     *         Range: 0 (not started) to 100 (complete).
     */
    public Double progress() {
        return progress;
    }

    /**
     * <p>
     * The size, in bytes, of data stored on the virtual tape.
     * </p>
     * <note>
     * <p>
     * This value is not available for tapes created prior to May 13, 2015.
     * </p>
     * </note>
     * 
     * @return The size, in bytes, of data stored on the virtual tape.</p> <note>
     *         <p>
     *         This value is not available for tapes created prior to May 13, 2015.
     *         </p>
     */
    public Long tapeUsedInBytes() {
        return tapeUsedInBytes;
    }

    /**
     * Returns the value of the KMSKey property for this object.
     * 
     * @return The value of the KMSKey property for this object.
     */
    public String kmsKey() {
        return kmsKey;
    }

    /**
     * <p>
     * The ID of the pool that contains tapes that will be archived. The tapes in this pool are archived in the S3
     * storage class that is associated with the pool. When you use your backup application to eject the tape, the tape
     * is archived directly into the storage class (S3 Glacier or S# Glacier Deep Archive) that corresponds to the pool.
     * </p>
     * <p>
     * Valid values: "GLACIER", "DEEP_ARCHIVE"
     * </p>
     * 
     * @return The ID of the pool that contains tapes that will be archived. The tapes in this pool are archived in the
     *         S3 storage class that is associated with the pool. When you use your backup application to eject the
     *         tape, the tape is archived directly into the storage class (S3 Glacier or S# Glacier Deep Archive) that
     *         corresponds to the pool.</p>
     *         <p>
     *         Valid values: "GLACIER", "DEEP_ARCHIVE"
     */
    public String poolId() {
        return poolId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tapeARN());
        hashCode = 31 * hashCode + Objects.hashCode(tapeBarcode());
        hashCode = 31 * hashCode + Objects.hashCode(tapeCreatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(tapeSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(tapeStatus());
        hashCode = 31 * hashCode + Objects.hashCode(vtlDevice());
        hashCode = 31 * hashCode + Objects.hashCode(progress());
        hashCode = 31 * hashCode + Objects.hashCode(tapeUsedInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(poolId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tape)) {
            return false;
        }
        Tape other = (Tape) obj;
        return Objects.equals(tapeARN(), other.tapeARN()) && Objects.equals(tapeBarcode(), other.tapeBarcode())
                && Objects.equals(tapeCreatedDate(), other.tapeCreatedDate())
                && Objects.equals(tapeSizeInBytes(), other.tapeSizeInBytes()) && Objects.equals(tapeStatus(), other.tapeStatus())
                && Objects.equals(vtlDevice(), other.vtlDevice()) && Objects.equals(progress(), other.progress())
                && Objects.equals(tapeUsedInBytes(), other.tapeUsedInBytes()) && Objects.equals(kmsKey(), other.kmsKey())
                && Objects.equals(poolId(), other.poolId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Tape").add("TapeARN", tapeARN()).add("TapeBarcode", tapeBarcode())
                .add("TapeCreatedDate", tapeCreatedDate()).add("TapeSizeInBytes", tapeSizeInBytes())
                .add("TapeStatus", tapeStatus()).add("VTLDevice", vtlDevice()).add("Progress", progress())
                .add("TapeUsedInBytes", tapeUsedInBytes()).add("KMSKey", kmsKey()).add("PoolId", poolId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TapeARN":
            return Optional.ofNullable(clazz.cast(tapeARN()));
        case "TapeBarcode":
            return Optional.ofNullable(clazz.cast(tapeBarcode()));
        case "TapeCreatedDate":
            return Optional.ofNullable(clazz.cast(tapeCreatedDate()));
        case "TapeSizeInBytes":
            return Optional.ofNullable(clazz.cast(tapeSizeInBytes()));
        case "TapeStatus":
            return Optional.ofNullable(clazz.cast(tapeStatus()));
        case "VTLDevice":
            return Optional.ofNullable(clazz.cast(vtlDevice()));
        case "Progress":
            return Optional.ofNullable(clazz.cast(progress()));
        case "TapeUsedInBytes":
            return Optional.ofNullable(clazz.cast(tapeUsedInBytes()));
        case "KMSKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        case "PoolId":
            return Optional.ofNullable(clazz.cast(poolId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Tape, T> g) {
        return obj -> g.apply((Tape) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Tape> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the virtual tape.
         * </p>
         * 
         * @param tapeARN
         *        The Amazon Resource Name (ARN) of the virtual tape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeARN(String tapeARN);

        /**
         * <p>
         * The barcode that identifies a specific virtual tape.
         * </p>
         * 
         * @param tapeBarcode
         *        The barcode that identifies a specific virtual tape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeBarcode(String tapeBarcode);

        /**
         * <p>
         * The date the virtual tape was created.
         * </p>
         * 
         * @param tapeCreatedDate
         *        The date the virtual tape was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeCreatedDate(Instant tapeCreatedDate);

        /**
         * <p>
         * The size, in bytes, of the virtual tape capacity.
         * </p>
         * 
         * @param tapeSizeInBytes
         *        The size, in bytes, of the virtual tape capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeSizeInBytes(Long tapeSizeInBytes);

        /**
         * <p>
         * The current state of the virtual tape.
         * </p>
         * 
         * @param tapeStatus
         *        The current state of the virtual tape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeStatus(String tapeStatus);

        /**
         * <p>
         * The virtual tape library (VTL) device that the virtual tape is associated with.
         * </p>
         * 
         * @param vtlDevice
         *        The virtual tape library (VTL) device that the virtual tape is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vtlDevice(String vtlDevice);

        /**
         * <p>
         * For archiving virtual tapes, indicates how much data remains to be uploaded before archiving is complete.
         * </p>
         * <p>
         * Range: 0 (not started) to 100 (complete).
         * </p>
         * 
         * @param progress
         *        For archiving virtual tapes, indicates how much data remains to be uploaded before archiving is
         *        complete.</p>
         *        <p>
         *        Range: 0 (not started) to 100 (complete).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(Double progress);

        /**
         * <p>
         * The size, in bytes, of data stored on the virtual tape.
         * </p>
         * <note>
         * <p>
         * This value is not available for tapes created prior to May 13, 2015.
         * </p>
         * </note>
         * 
         * @param tapeUsedInBytes
         *        The size, in bytes, of data stored on the virtual tape.</p> <note>
         *        <p>
         *        This value is not available for tapes created prior to May 13, 2015.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeUsedInBytes(Long tapeUsedInBytes);

        /**
         * Sets the value of the KMSKey property for this object.
         *
         * @param kmsKey
         *        The new value for the KMSKey property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        /**
         * <p>
         * The ID of the pool that contains tapes that will be archived. The tapes in this pool are archived in the S3
         * storage class that is associated with the pool. When you use your backup application to eject the tape, the
         * tape is archived directly into the storage class (S3 Glacier or S# Glacier Deep Archive) that corresponds to
         * the pool.
         * </p>
         * <p>
         * Valid values: "GLACIER", "DEEP_ARCHIVE"
         * </p>
         * 
         * @param poolId
         *        The ID of the pool that contains tapes that will be archived. The tapes in this pool are archived in
         *        the S3 storage class that is associated with the pool. When you use your backup application to eject
         *        the tape, the tape is archived directly into the storage class (S3 Glacier or S# Glacier Deep Archive)
         *        that corresponds to the pool.</p>
         *        <p>
         *        Valid values: "GLACIER", "DEEP_ARCHIVE"
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolId(String poolId);
    }

    static final class BuilderImpl implements Builder {
        private String tapeARN;

        private String tapeBarcode;

        private Instant tapeCreatedDate;

        private Long tapeSizeInBytes;

        private String tapeStatus;

        private String vtlDevice;

        private Double progress;

        private Long tapeUsedInBytes;

        private String kmsKey;

        private String poolId;

        private BuilderImpl() {
        }

        private BuilderImpl(Tape model) {
            tapeARN(model.tapeARN);
            tapeBarcode(model.tapeBarcode);
            tapeCreatedDate(model.tapeCreatedDate);
            tapeSizeInBytes(model.tapeSizeInBytes);
            tapeStatus(model.tapeStatus);
            vtlDevice(model.vtlDevice);
            progress(model.progress);
            tapeUsedInBytes(model.tapeUsedInBytes);
            kmsKey(model.kmsKey);
            poolId(model.poolId);
        }

        public final String getTapeARN() {
            return tapeARN;
        }

        @Override
        public final Builder tapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
            return this;
        }

        public final void setTapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
        }

        public final String getTapeBarcode() {
            return tapeBarcode;
        }

        @Override
        public final Builder tapeBarcode(String tapeBarcode) {
            this.tapeBarcode = tapeBarcode;
            return this;
        }

        public final void setTapeBarcode(String tapeBarcode) {
            this.tapeBarcode = tapeBarcode;
        }

        public final Instant getTapeCreatedDate() {
            return tapeCreatedDate;
        }

        @Override
        public final Builder tapeCreatedDate(Instant tapeCreatedDate) {
            this.tapeCreatedDate = tapeCreatedDate;
            return this;
        }

        public final void setTapeCreatedDate(Instant tapeCreatedDate) {
            this.tapeCreatedDate = tapeCreatedDate;
        }

        public final Long getTapeSizeInBytes() {
            return tapeSizeInBytes;
        }

        @Override
        public final Builder tapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
            return this;
        }

        public final void setTapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
        }

        public final String getTapeStatus() {
            return tapeStatus;
        }

        @Override
        public final Builder tapeStatus(String tapeStatus) {
            this.tapeStatus = tapeStatus;
            return this;
        }

        public final void setTapeStatus(String tapeStatus) {
            this.tapeStatus = tapeStatus;
        }

        public final String getVtlDevice() {
            return vtlDevice;
        }

        @Override
        public final Builder vtlDevice(String vtlDevice) {
            this.vtlDevice = vtlDevice;
            return this;
        }

        public final void setVtlDevice(String vtlDevice) {
            this.vtlDevice = vtlDevice;
        }

        public final Double getProgress() {
            return progress;
        }

        @Override
        public final Builder progress(Double progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(Double progress) {
            this.progress = progress;
        }

        public final Long getTapeUsedInBytes() {
            return tapeUsedInBytes;
        }

        @Override
        public final Builder tapeUsedInBytes(Long tapeUsedInBytes) {
            this.tapeUsedInBytes = tapeUsedInBytes;
            return this;
        }

        public final void setTapeUsedInBytes(Long tapeUsedInBytes) {
            this.tapeUsedInBytes = tapeUsedInBytes;
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        public final String getPoolId() {
            return poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public Tape build() {
            return new Tape(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
