/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLocalDisksResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<ListLocalDisksResponse.Builder, ListLocalDisksResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListLocalDisksResponse::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<List<Disk>> DISKS_FIELD = SdkField
            .<List<Disk>> builder(MarshallingType.LIST)
            .getter(getter(ListLocalDisksResponse::disks))
            .setter(setter(Builder::disks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Disk> builder(MarshallingType.SDK_POJO)
                                            .constructor(Disk::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(GATEWAY_ARN_FIELD, DISKS_FIELD));

    private final String gatewayARN;

    private final List<Disk> disks;

    private ListLocalDisksResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.disks = builder.disks;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public String gatewayARN() {
        return gatewayARN;
    }

    /**
     * Returns true if the Disks property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDisks() {
        return disks != null && !(disks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A JSON object containing the following fields:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>ListLocalDisksOutput$Disks</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDisks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A JSON object containing the following fields:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a>ListLocalDisksOutput$Disks</a>
     *         </p>
     *         </li>
     */
    public List<Disk> disks() {
        return disks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(disks());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLocalDisksResponse)) {
            return false;
        }
        ListLocalDisksResponse other = (ListLocalDisksResponse) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(disks(), other.disks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListLocalDisksResponse").add("GatewayARN", gatewayARN()).add("Disks", disks()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "Disks":
            return Optional.ofNullable(clazz.cast(disks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLocalDisksResponse, T> g) {
        return obj -> g.apply((ListLocalDisksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListLocalDisksResponse> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * A JSON object containing the following fields:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>ListLocalDisksOutput$Disks</a>
         * </p>
         * </li>
         * </ul>
         * 
         * @param disks
         *        A JSON object containing the following fields:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a>ListLocalDisksOutput$Disks</a>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disks(Collection<Disk> disks);

        /**
         * <p>
         * A JSON object containing the following fields:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>ListLocalDisksOutput$Disks</a>
         * </p>
         * </li>
         * </ul>
         * 
         * @param disks
         *        A JSON object containing the following fields:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a>ListLocalDisksOutput$Disks</a>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disks(Disk... disks);

        /**
         * <p>
         * A JSON object containing the following fields:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>ListLocalDisksOutput$Disks</a>
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Disk>.Builder} avoiding the need to create
         * one manually via {@link List<Disk>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Disk>.Builder#build()} is called immediately and its result
         * is passed to {@link #disks(List<Disk>)}.
         * 
         * @param disks
         *        a consumer that will call methods on {@link List<Disk>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #disks(List<Disk>)
         */
        Builder disks(Consumer<Disk.Builder>... disks);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String gatewayARN;

        private List<Disk> disks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListLocalDisksResponse model) {
            super(model);
            gatewayARN(model.gatewayARN);
            disks(model.disks);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final Collection<Disk.Builder> getDisks() {
            return disks != null ? disks.stream().map(Disk::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder disks(Collection<Disk> disks) {
            this.disks = DisksCopier.copy(disks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disks(Disk... disks) {
            disks(Arrays.asList(disks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disks(Consumer<Disk.Builder>... disks) {
            disks(Stream.of(disks).map(c -> Disk.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDisks(Collection<Disk.BuilderImpl> disks) {
            this.disks = DisksCopier.copyFromBuilder(disks);
        }

        @Override
        public ListLocalDisksResponse build() {
            return new ListLocalDisksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
