/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * ListFileShareOutput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFileSharesResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<ListFileSharesResponse.Builder, ListFileSharesResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListFileSharesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListFileSharesResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final SdkField<List<FileShareInfo>> FILE_SHARE_INFO_LIST_FIELD = SdkField
            .<List<FileShareInfo>> builder(MarshallingType.LIST)
            .getter(getter(ListFileSharesResponse::fileShareInfoList))
            .setter(setter(Builder::fileShareInfoList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareInfoList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FileShareInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(FileShareInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            NEXT_MARKER_FIELD, FILE_SHARE_INFO_LIST_FIELD));

    private final String marker;

    private final String nextMarker;

    private final List<FileShareInfo> fileShareInfoList;

    private ListFileSharesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.nextMarker = builder.nextMarker;
        this.fileShareInfoList = builder.fileShareInfoList;
    }

    /**
     * <p>
     * If the request includes <code>Marker</code>, the response returns that value in this field.
     * </p>
     * 
     * @return If the request includes <code>Marker</code>, the response returns that value in this field.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * If a value is present, there are more file shares to return. In a subsequent request, use <code>NextMarker</code>
     * as the value for <code>Marker</code> to retrieve the next set of file shares.
     * </p>
     * 
     * @return If a value is present, there are more file shares to return. In a subsequent request, use
     *         <code>NextMarker</code> as the value for <code>Marker</code> to retrieve the next set of file shares.
     */
    public String nextMarker() {
        return nextMarker;
    }

    /**
     * Returns true if the FileShareInfoList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasFileShareInfoList() {
        return fileShareInfoList != null && !(fileShareInfoList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of information about the file gateway's file shares.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFileShareInfoList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of information about the file gateway's file shares.
     */
    public List<FileShareInfo> fileShareInfoList() {
        return fileShareInfoList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(fileShareInfoList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFileSharesResponse)) {
            return false;
        }
        ListFileSharesResponse other = (ListFileSharesResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(nextMarker(), other.nextMarker())
                && Objects.equals(fileShareInfoList(), other.fileShareInfoList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListFileSharesResponse").add("Marker", marker()).add("NextMarker", nextMarker())
                .add("FileShareInfoList", fileShareInfoList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "FileShareInfoList":
            return Optional.ofNullable(clazz.cast(fileShareInfoList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFileSharesResponse, T> g) {
        return obj -> g.apply((ListFileSharesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFileSharesResponse> {
        /**
         * <p>
         * If the request includes <code>Marker</code>, the response returns that value in this field.
         * </p>
         * 
         * @param marker
         *        If the request includes <code>Marker</code>, the response returns that value in this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * If a value is present, there are more file shares to return. In a subsequent request, use
         * <code>NextMarker</code> as the value for <code>Marker</code> to retrieve the next set of file shares.
         * </p>
         * 
         * @param nextMarker
         *        If a value is present, there are more file shares to return. In a subsequent request, use
         *        <code>NextMarker</code> as the value for <code>Marker</code> to retrieve the next set of file shares.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * An array of information about the file gateway's file shares.
         * </p>
         * 
         * @param fileShareInfoList
         *        An array of information about the file gateway's file shares.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileShareInfoList(Collection<FileShareInfo> fileShareInfoList);

        /**
         * <p>
         * An array of information about the file gateway's file shares.
         * </p>
         * 
         * @param fileShareInfoList
         *        An array of information about the file gateway's file shares.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileShareInfoList(FileShareInfo... fileShareInfoList);

        /**
         * <p>
         * An array of information about the file gateway's file shares.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FileShareInfo>.Builder} avoiding the need
         * to create one manually via {@link List<FileShareInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FileShareInfo>.Builder#build()} is called immediately and
         * its result is passed to {@link #fileShareInfoList(List<FileShareInfo>)}.
         * 
         * @param fileShareInfoList
         *        a consumer that will call methods on {@link List<FileShareInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileShareInfoList(List<FileShareInfo>)
         */
        Builder fileShareInfoList(Consumer<FileShareInfo.Builder>... fileShareInfoList);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String marker;

        private String nextMarker;

        private List<FileShareInfo> fileShareInfoList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFileSharesResponse model) {
            super(model);
            marker(model.marker);
            nextMarker(model.nextMarker);
            fileShareInfoList(model.fileShareInfoList);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<FileShareInfo.Builder> getFileShareInfoList() {
            return fileShareInfoList != null ? fileShareInfoList.stream().map(FileShareInfo::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fileShareInfoList(Collection<FileShareInfo> fileShareInfoList) {
            this.fileShareInfoList = FileShareInfoListCopier.copy(fileShareInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileShareInfoList(FileShareInfo... fileShareInfoList) {
            fileShareInfoList(Arrays.asList(fileShareInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileShareInfoList(Consumer<FileShareInfo.Builder>... fileShareInfoList) {
            fileShareInfoList(Stream.of(fileShareInfoList).map(c -> FileShareInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFileShareInfoList(Collection<FileShareInfo.BuilderImpl> fileShareInfoList) {
            this.fileShareInfoList = FileShareInfoListCopier.copyFromBuilder(fileShareInfoList);
        }

        @Override
        public ListFileSharesResponse build() {
            return new ListFileSharesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
