/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * JoinDomainInput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JoinDomainRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<JoinDomainRequest.Builder, JoinDomainRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JoinDomainRequest::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JoinDomainRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> ORGANIZATIONAL_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JoinDomainRequest::organizationalUnit)).setter(setter(Builder::organizationalUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnit").build())
            .build();

    private static final SdkField<List<String>> DOMAIN_CONTROLLERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(JoinDomainRequest::domainControllers))
            .setter(setter(Builder::domainControllers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainControllers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> TIMEOUT_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(JoinDomainRequest::timeoutInSeconds)).setter(setter(Builder::timeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutInSeconds").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JoinDomainRequest::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JoinDomainRequest::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            DOMAIN_NAME_FIELD, ORGANIZATIONAL_UNIT_FIELD, DOMAIN_CONTROLLERS_FIELD, TIMEOUT_IN_SECONDS_FIELD, USER_NAME_FIELD,
            PASSWORD_FIELD));

    private final String gatewayARN;

    private final String domainName;

    private final String organizationalUnit;

    private final List<String> domainControllers;

    private final Integer timeoutInSeconds;

    private final String userName;

    private final String password;

    private JoinDomainRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.domainName = builder.domainName;
        this.organizationalUnit = builder.organizationalUnit;
        this.domainControllers = builder.domainControllers;
        this.timeoutInSeconds = builder.timeoutInSeconds;
        this.userName = builder.userName;
        this.password = builder.password;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of
     * gateways for your account and AWS Region.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a
     *         list of gateways for your account and AWS Region.
     */
    public String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * The name of the domain that you want the gateway to join.
     * </p>
     * 
     * @return The name of the domain that you want the gateway to join.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The organizational unit (OU) is a container in an Active Directory that can hold users, groups, computers, and
     * other OUs and this parameter specifies the OU that the gateway will join within the AD domain.
     * </p>
     * 
     * @return The organizational unit (OU) is a container in an Active Directory that can hold users, groups,
     *         computers, and other OUs and this parameter specifies the OU that the gateway will join within the AD
     *         domain.
     */
    public String organizationalUnit() {
        return organizationalUnit;
    }

    /**
     * Returns true if the DomainControllers property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDomainControllers() {
        return domainControllers != null && !(domainControllers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of IPv4 addresses, NetBIOS names, or host names of your domain server. If you need to specify the port
     * number include it after the colon (“:”). For example, <code>mydc.mydomain.com:389</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDomainControllers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of IPv4 addresses, NetBIOS names, or host names of your domain server. If you need to specify the
     *         port number include it after the colon (“:”). For example, <code>mydc.mydomain.com:389</code>.
     */
    public List<String> domainControllers() {
        return domainControllers;
    }

    /**
     * <p>
     * Specifies the time in seconds, in which the <code>JoinDomain</code> operation must complete. The default is 20
     * seconds.
     * </p>
     * 
     * @return Specifies the time in seconds, in which the <code>JoinDomain</code> operation must complete. The default
     *         is 20 seconds.
     */
    public Integer timeoutInSeconds() {
        return timeoutInSeconds;
    }

    /**
     * <p>
     * Sets the user name of user who has permission to add the gateway to the Active Directory domain. The domain user
     * account should be enabled to join computers to the domain. For example, you can use the domain administrator
     * account or an account with delegated permissions to join computers to the domain.
     * </p>
     * 
     * @return Sets the user name of user who has permission to add the gateway to the Active Directory domain. The
     *         domain user account should be enabled to join computers to the domain. For example, you can use the
     *         domain administrator account or an account with delegated permissions to join computers to the domain.
     */
    public String userName() {
        return userName;
    }

    /**
     * <p>
     * Sets the password of the user who has permission to add the gateway to the Active Directory domain.
     * </p>
     * 
     * @return Sets the password of the user who has permission to add the gateway to the Active Directory domain.
     */
    public String password() {
        return password;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnit());
        hashCode = 31 * hashCode + Objects.hashCode(domainControllers());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JoinDomainRequest)) {
            return false;
        }
        JoinDomainRequest other = (JoinDomainRequest) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(domainName(), other.domainName())
                && Objects.equals(organizationalUnit(), other.organizationalUnit())
                && Objects.equals(domainControllers(), other.domainControllers())
                && Objects.equals(timeoutInSeconds(), other.timeoutInSeconds()) && Objects.equals(userName(), other.userName())
                && Objects.equals(password(), other.password());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("JoinDomainRequest").add("GatewayARN", gatewayARN()).add("DomainName", domainName())
                .add("OrganizationalUnit", organizationalUnit()).add("DomainControllers", domainControllers())
                .add("TimeoutInSeconds", timeoutInSeconds()).add("UserName", userName())
                .add("Password", password() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "OrganizationalUnit":
            return Optional.ofNullable(clazz.cast(organizationalUnit()));
        case "DomainControllers":
            return Optional.ofNullable(clazz.cast(domainControllers()));
        case "TimeoutInSeconds":
            return Optional.ofNullable(clazz.cast(timeoutInSeconds()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JoinDomainRequest, T> g) {
        return obj -> g.apply((JoinDomainRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, JoinDomainRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list
         * of gateways for your account and AWS Region.
         * </p>
         * 
         * @param gatewayARN
         *        The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a
         *        list of gateways for your account and AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * The name of the domain that you want the gateway to join.
         * </p>
         * 
         * @param domainName
         *        The name of the domain that you want the gateway to join.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The organizational unit (OU) is a container in an Active Directory that can hold users, groups, computers,
         * and other OUs and this parameter specifies the OU that the gateway will join within the AD domain.
         * </p>
         * 
         * @param organizationalUnit
         *        The organizational unit (OU) is a container in an Active Directory that can hold users, groups,
         *        computers, and other OUs and this parameter specifies the OU that the gateway will join within the AD
         *        domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnit(String organizationalUnit);

        /**
         * <p>
         * List of IPv4 addresses, NetBIOS names, or host names of your domain server. If you need to specify the port
         * number include it after the colon (“:”). For example, <code>mydc.mydomain.com:389</code>.
         * </p>
         * 
         * @param domainControllers
         *        List of IPv4 addresses, NetBIOS names, or host names of your domain server. If you need to specify the
         *        port number include it after the colon (“:”). For example, <code>mydc.mydomain.com:389</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainControllers(Collection<String> domainControllers);

        /**
         * <p>
         * List of IPv4 addresses, NetBIOS names, or host names of your domain server. If you need to specify the port
         * number include it after the colon (“:”). For example, <code>mydc.mydomain.com:389</code>.
         * </p>
         * 
         * @param domainControllers
         *        List of IPv4 addresses, NetBIOS names, or host names of your domain server. If you need to specify the
         *        port number include it after the colon (“:”). For example, <code>mydc.mydomain.com:389</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainControllers(String... domainControllers);

        /**
         * <p>
         * Specifies the time in seconds, in which the <code>JoinDomain</code> operation must complete. The default is
         * 20 seconds.
         * </p>
         * 
         * @param timeoutInSeconds
         *        Specifies the time in seconds, in which the <code>JoinDomain</code> operation must complete. The
         *        default is 20 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInSeconds(Integer timeoutInSeconds);

        /**
         * <p>
         * Sets the user name of user who has permission to add the gateway to the Active Directory domain. The domain
         * user account should be enabled to join computers to the domain. For example, you can use the domain
         * administrator account or an account with delegated permissions to join computers to the domain.
         * </p>
         * 
         * @param userName
         *        Sets the user name of user who has permission to add the gateway to the Active Directory domain. The
         *        domain user account should be enabled to join computers to the domain. For example, you can use the
         *        domain administrator account or an account with delegated permissions to join computers to the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * Sets the password of the user who has permission to add the gateway to the Active Directory domain.
         * </p>
         * 
         * @param password
         *        Sets the password of the user who has permission to add the gateway to the Active Directory domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String gatewayARN;

        private String domainName;

        private String organizationalUnit;

        private List<String> domainControllers = DefaultSdkAutoConstructList.getInstance();

        private Integer timeoutInSeconds;

        private String userName;

        private String password;

        private BuilderImpl() {
        }

        private BuilderImpl(JoinDomainRequest model) {
            super(model);
            gatewayARN(model.gatewayARN);
            domainName(model.domainName);
            organizationalUnit(model.organizationalUnit);
            domainControllers(model.domainControllers);
            timeoutInSeconds(model.timeoutInSeconds);
            userName(model.userName);
            password(model.password);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getOrganizationalUnit() {
            return organizationalUnit;
        }

        @Override
        public final Builder organizationalUnit(String organizationalUnit) {
            this.organizationalUnit = organizationalUnit;
            return this;
        }

        public final void setOrganizationalUnit(String organizationalUnit) {
            this.organizationalUnit = organizationalUnit;
        }

        public final Collection<String> getDomainControllers() {
            return domainControllers;
        }

        @Override
        public final Builder domainControllers(Collection<String> domainControllers) {
            this.domainControllers = HostsCopier.copy(domainControllers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainControllers(String... domainControllers) {
            domainControllers(Arrays.asList(domainControllers));
            return this;
        }

        public final void setDomainControllers(Collection<String> domainControllers) {
            this.domainControllers = HostsCopier.copy(domainControllers);
        }

        public final Integer getTimeoutInSeconds() {
            return timeoutInSeconds;
        }

        @Override
        public final Builder timeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public final void setTimeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        public final String getUserName() {
            return userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getPassword() {
            return password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public JoinDomainRequest build() {
            return new JoinDomainRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
