/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSmbSettingsResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<DescribeSmbSettingsResponse.Builder, DescribeSmbSettingsResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSmbSettingsResponse::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSmbSettingsResponse::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> ACTIVE_DIRECTORY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSmbSettingsResponse::activeDirectoryStatusAsString))
            .setter(setter(Builder::activeDirectoryStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectoryStatus").build())
            .build();

    private static final SdkField<Boolean> SMB_GUEST_PASSWORD_SET_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DescribeSmbSettingsResponse::smbGuestPasswordSet)).setter(setter(Builder::smbGuestPasswordSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMBGuestPasswordSet").build())
            .build();

    private static final SdkField<String> SMB_SECURITY_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSmbSettingsResponse::smbSecurityStrategyAsString))
            .setter(setter(Builder::smbSecurityStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMBSecurityStrategy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            DOMAIN_NAME_FIELD, ACTIVE_DIRECTORY_STATUS_FIELD, SMB_GUEST_PASSWORD_SET_FIELD, SMB_SECURITY_STRATEGY_FIELD));

    private final String gatewayARN;

    private final String domainName;

    private final String activeDirectoryStatus;

    private final Boolean smbGuestPasswordSet;

    private final String smbSecurityStrategy;

    private DescribeSmbSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.domainName = builder.domainName;
        this.activeDirectoryStatus = builder.activeDirectoryStatus;
        this.smbGuestPasswordSet = builder.smbGuestPasswordSet;
        this.smbSecurityStrategy = builder.smbSecurityStrategy;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * The name of the domain that the gateway is joined to.
     * </p>
     * 
     * @return The name of the domain that the gateway is joined to.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Indicates the status of a gateway that is a member of the Active Directory domain.
     * </p>
     * <ul>
     * <li>
     * <p>
     * ACCESS_DENIED: Indicates that the <code>JoinDomain</code> operation failed due to an authentication error.
     * </p>
     * </li>
     * <li>
     * <p>
     * DETACHED: Indicates that gateway is not joined to a domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * JOINED: Indicates that the gateway has successfully joined a domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * JOINING: Indicates that a <code>JoinDomain</code> operation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * NETWORK_ERROR: Indicates that <code>JoinDomain</code> operation failed due to a network or connectivity error.
     * </p>
     * </li>
     * <li>
     * <p>
     * TIMEOUT: Indicates that the <code>JoinDomain</code> operation failed because the operation didn't complete within
     * the allotted time.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNKNOWN_ERROR: Indicates that the <code>JoinDomain</code> operation failed due to another type of error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #activeDirectoryStatus} will return {@link ActiveDirectoryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #activeDirectoryStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of a gateway that is a member of the Active Directory domain.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCESS_DENIED: Indicates that the <code>JoinDomain</code> operation failed due to an authentication
     *         error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DETACHED: Indicates that gateway is not joined to a domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         JOINED: Indicates that the gateway has successfully joined a domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         JOINING: Indicates that a <code>JoinDomain</code> operation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NETWORK_ERROR: Indicates that <code>JoinDomain</code> operation failed due to a network or connectivity
     *         error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TIMEOUT: Indicates that the <code>JoinDomain</code> operation failed because the operation didn't
     *         complete within the allotted time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNKNOWN_ERROR: Indicates that the <code>JoinDomain</code> operation failed due to another type of error.
     *         </p>
     *         </li>
     * @see ActiveDirectoryStatus
     */
    public ActiveDirectoryStatus activeDirectoryStatus() {
        return ActiveDirectoryStatus.fromValue(activeDirectoryStatus);
    }

    /**
     * <p>
     * Indicates the status of a gateway that is a member of the Active Directory domain.
     * </p>
     * <ul>
     * <li>
     * <p>
     * ACCESS_DENIED: Indicates that the <code>JoinDomain</code> operation failed due to an authentication error.
     * </p>
     * </li>
     * <li>
     * <p>
     * DETACHED: Indicates that gateway is not joined to a domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * JOINED: Indicates that the gateway has successfully joined a domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * JOINING: Indicates that a <code>JoinDomain</code> operation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * NETWORK_ERROR: Indicates that <code>JoinDomain</code> operation failed due to a network or connectivity error.
     * </p>
     * </li>
     * <li>
     * <p>
     * TIMEOUT: Indicates that the <code>JoinDomain</code> operation failed because the operation didn't complete within
     * the allotted time.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNKNOWN_ERROR: Indicates that the <code>JoinDomain</code> operation failed due to another type of error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #activeDirectoryStatus} will return {@link ActiveDirectoryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #activeDirectoryStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of a gateway that is a member of the Active Directory domain.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCESS_DENIED: Indicates that the <code>JoinDomain</code> operation failed due to an authentication
     *         error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DETACHED: Indicates that gateway is not joined to a domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         JOINED: Indicates that the gateway has successfully joined a domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         JOINING: Indicates that a <code>JoinDomain</code> operation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NETWORK_ERROR: Indicates that <code>JoinDomain</code> operation failed due to a network or connectivity
     *         error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TIMEOUT: Indicates that the <code>JoinDomain</code> operation failed because the operation didn't
     *         complete within the allotted time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNKNOWN_ERROR: Indicates that the <code>JoinDomain</code> operation failed due to another type of error.
     *         </p>
     *         </li>
     * @see ActiveDirectoryStatus
     */
    public String activeDirectoryStatusAsString() {
        return activeDirectoryStatus;
    }

    /**
     * <p>
     * This value is true if a password for the guest user “smbguest” is set, and otherwise false.
     * </p>
     * 
     * @return This value is true if a password for the guest user “smbguest” is set, and otherwise false.
     */
    public Boolean smbGuestPasswordSet() {
        return smbGuestPasswordSet;
    }

    /**
     * <p>
     * The type of security strategy that was specified for file gateway.
     * </p>
     * <p>
     * ClientSpecified: if you use this option, requests are established based on what is negotiated by the client. This
     * option is recommended when you want to maximize compatibility across different clients in your environment.
     * </p>
     * <p>
     * MandatorySigning: if you use this option, file gateway only allows connections from SMBv2 or SMBv3 clients that
     * have signing enabled. This option works with SMB clients on Microsoft Windows Vista, Windows Server 2008 or
     * newer.
     * </p>
     * <p>
     * MandatoryEncryption: if you use this option, file gateway only allows connections from SMBv3 clients that have
     * encryption enabled. This option is highly recommended for environments that handle sensitive data. This option
     * works with SMB clients on Microsoft Windows 8, Windows Server 2012 or newer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #smbSecurityStrategy} will return {@link SMBSecurityStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #smbSecurityStrategyAsString}.
     * </p>
     * 
     * @return The type of security strategy that was specified for file gateway.</p>
     *         <p>
     *         ClientSpecified: if you use this option, requests are established based on what is negotiated by the
     *         client. This option is recommended when you want to maximize compatibility across different clients in
     *         your environment.
     *         </p>
     *         <p>
     *         MandatorySigning: if you use this option, file gateway only allows connections from SMBv2 or SMBv3
     *         clients that have signing enabled. This option works with SMB clients on Microsoft Windows Vista, Windows
     *         Server 2008 or newer.
     *         </p>
     *         <p>
     *         MandatoryEncryption: if you use this option, file gateway only allows connections from SMBv3 clients that
     *         have encryption enabled. This option is highly recommended for environments that handle sensitive data.
     *         This option works with SMB clients on Microsoft Windows 8, Windows Server 2012 or newer.
     * @see SMBSecurityStrategy
     */
    public SMBSecurityStrategy smbSecurityStrategy() {
        return SMBSecurityStrategy.fromValue(smbSecurityStrategy);
    }

    /**
     * <p>
     * The type of security strategy that was specified for file gateway.
     * </p>
     * <p>
     * ClientSpecified: if you use this option, requests are established based on what is negotiated by the client. This
     * option is recommended when you want to maximize compatibility across different clients in your environment.
     * </p>
     * <p>
     * MandatorySigning: if you use this option, file gateway only allows connections from SMBv2 or SMBv3 clients that
     * have signing enabled. This option works with SMB clients on Microsoft Windows Vista, Windows Server 2008 or
     * newer.
     * </p>
     * <p>
     * MandatoryEncryption: if you use this option, file gateway only allows connections from SMBv3 clients that have
     * encryption enabled. This option is highly recommended for environments that handle sensitive data. This option
     * works with SMB clients on Microsoft Windows 8, Windows Server 2012 or newer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #smbSecurityStrategy} will return {@link SMBSecurityStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #smbSecurityStrategyAsString}.
     * </p>
     * 
     * @return The type of security strategy that was specified for file gateway.</p>
     *         <p>
     *         ClientSpecified: if you use this option, requests are established based on what is negotiated by the
     *         client. This option is recommended when you want to maximize compatibility across different clients in
     *         your environment.
     *         </p>
     *         <p>
     *         MandatorySigning: if you use this option, file gateway only allows connections from SMBv2 or SMBv3
     *         clients that have signing enabled. This option works with SMB clients on Microsoft Windows Vista, Windows
     *         Server 2008 or newer.
     *         </p>
     *         <p>
     *         MandatoryEncryption: if you use this option, file gateway only allows connections from SMBv3 clients that
     *         have encryption enabled. This option is highly recommended for environments that handle sensitive data.
     *         This option works with SMB clients on Microsoft Windows 8, Windows Server 2012 or newer.
     * @see SMBSecurityStrategy
     */
    public String smbSecurityStrategyAsString() {
        return smbSecurityStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(activeDirectoryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(smbGuestPasswordSet());
        hashCode = 31 * hashCode + Objects.hashCode(smbSecurityStrategyAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSmbSettingsResponse)) {
            return false;
        }
        DescribeSmbSettingsResponse other = (DescribeSmbSettingsResponse) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(domainName(), other.domainName())
                && Objects.equals(activeDirectoryStatusAsString(), other.activeDirectoryStatusAsString())
                && Objects.equals(smbGuestPasswordSet(), other.smbGuestPasswordSet())
                && Objects.equals(smbSecurityStrategyAsString(), other.smbSecurityStrategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeSmbSettingsResponse").add("GatewayARN", gatewayARN()).add("DomainName", domainName())
                .add("ActiveDirectoryStatus", activeDirectoryStatusAsString()).add("SMBGuestPasswordSet", smbGuestPasswordSet())
                .add("SMBSecurityStrategy", smbSecurityStrategyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "ActiveDirectoryStatus":
            return Optional.ofNullable(clazz.cast(activeDirectoryStatusAsString()));
        case "SMBGuestPasswordSet":
            return Optional.ofNullable(clazz.cast(smbGuestPasswordSet()));
        case "SMBSecurityStrategy":
            return Optional.ofNullable(clazz.cast(smbSecurityStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSmbSettingsResponse, T> g) {
        return obj -> g.apply((DescribeSmbSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSmbSettingsResponse> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * The name of the domain that the gateway is joined to.
         * </p>
         * 
         * @param domainName
         *        The name of the domain that the gateway is joined to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Indicates the status of a gateway that is a member of the Active Directory domain.
         * </p>
         * <ul>
         * <li>
         * <p>
         * ACCESS_DENIED: Indicates that the <code>JoinDomain</code> operation failed due to an authentication error.
         * </p>
         * </li>
         * <li>
         * <p>
         * DETACHED: Indicates that gateway is not joined to a domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * JOINED: Indicates that the gateway has successfully joined a domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * JOINING: Indicates that a <code>JoinDomain</code> operation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * NETWORK_ERROR: Indicates that <code>JoinDomain</code> operation failed due to a network or connectivity
         * error.
         * </p>
         * </li>
         * <li>
         * <p>
         * TIMEOUT: Indicates that the <code>JoinDomain</code> operation failed because the operation didn't complete
         * within the allotted time.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNKNOWN_ERROR: Indicates that the <code>JoinDomain</code> operation failed due to another type of error.
         * </p>
         * </li>
         * </ul>
         * 
         * @param activeDirectoryStatus
         *        Indicates the status of a gateway that is a member of the Active Directory domain.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ACCESS_DENIED: Indicates that the <code>JoinDomain</code> operation failed due to an authentication
         *        error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DETACHED: Indicates that gateway is not joined to a domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        JOINED: Indicates that the gateway has successfully joined a domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        JOINING: Indicates that a <code>JoinDomain</code> operation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NETWORK_ERROR: Indicates that <code>JoinDomain</code> operation failed due to a network or
         *        connectivity error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TIMEOUT: Indicates that the <code>JoinDomain</code> operation failed because the operation didn't
         *        complete within the allotted time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNKNOWN_ERROR: Indicates that the <code>JoinDomain</code> operation failed due to another type of
         *        error.
         *        </p>
         *        </li>
         * @see ActiveDirectoryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActiveDirectoryStatus
         */
        Builder activeDirectoryStatus(String activeDirectoryStatus);

        /**
         * <p>
         * Indicates the status of a gateway that is a member of the Active Directory domain.
         * </p>
         * <ul>
         * <li>
         * <p>
         * ACCESS_DENIED: Indicates that the <code>JoinDomain</code> operation failed due to an authentication error.
         * </p>
         * </li>
         * <li>
         * <p>
         * DETACHED: Indicates that gateway is not joined to a domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * JOINED: Indicates that the gateway has successfully joined a domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * JOINING: Indicates that a <code>JoinDomain</code> operation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * NETWORK_ERROR: Indicates that <code>JoinDomain</code> operation failed due to a network or connectivity
         * error.
         * </p>
         * </li>
         * <li>
         * <p>
         * TIMEOUT: Indicates that the <code>JoinDomain</code> operation failed because the operation didn't complete
         * within the allotted time.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNKNOWN_ERROR: Indicates that the <code>JoinDomain</code> operation failed due to another type of error.
         * </p>
         * </li>
         * </ul>
         * 
         * @param activeDirectoryStatus
         *        Indicates the status of a gateway that is a member of the Active Directory domain.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ACCESS_DENIED: Indicates that the <code>JoinDomain</code> operation failed due to an authentication
         *        error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DETACHED: Indicates that gateway is not joined to a domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        JOINED: Indicates that the gateway has successfully joined a domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        JOINING: Indicates that a <code>JoinDomain</code> operation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NETWORK_ERROR: Indicates that <code>JoinDomain</code> operation failed due to a network or
         *        connectivity error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TIMEOUT: Indicates that the <code>JoinDomain</code> operation failed because the operation didn't
         *        complete within the allotted time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNKNOWN_ERROR: Indicates that the <code>JoinDomain</code> operation failed due to another type of
         *        error.
         *        </p>
         *        </li>
         * @see ActiveDirectoryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActiveDirectoryStatus
         */
        Builder activeDirectoryStatus(ActiveDirectoryStatus activeDirectoryStatus);

        /**
         * <p>
         * This value is true if a password for the guest user “smbguest” is set, and otherwise false.
         * </p>
         * 
         * @param smbGuestPasswordSet
         *        This value is true if a password for the guest user “smbguest” is set, and otherwise false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smbGuestPasswordSet(Boolean smbGuestPasswordSet);

        /**
         * <p>
         * The type of security strategy that was specified for file gateway.
         * </p>
         * <p>
         * ClientSpecified: if you use this option, requests are established based on what is negotiated by the client.
         * This option is recommended when you want to maximize compatibility across different clients in your
         * environment.
         * </p>
         * <p>
         * MandatorySigning: if you use this option, file gateway only allows connections from SMBv2 or SMBv3 clients
         * that have signing enabled. This option works with SMB clients on Microsoft Windows Vista, Windows Server 2008
         * or newer.
         * </p>
         * <p>
         * MandatoryEncryption: if you use this option, file gateway only allows connections from SMBv3 clients that
         * have encryption enabled. This option is highly recommended for environments that handle sensitive data. This
         * option works with SMB clients on Microsoft Windows 8, Windows Server 2012 or newer.
         * </p>
         * 
         * @param smbSecurityStrategy
         *        The type of security strategy that was specified for file gateway.</p>
         *        <p>
         *        ClientSpecified: if you use this option, requests are established based on what is negotiated by the
         *        client. This option is recommended when you want to maximize compatibility across different clients in
         *        your environment.
         *        </p>
         *        <p>
         *        MandatorySigning: if you use this option, file gateway only allows connections from SMBv2 or SMBv3
         *        clients that have signing enabled. This option works with SMB clients on Microsoft Windows Vista,
         *        Windows Server 2008 or newer.
         *        </p>
         *        <p>
         *        MandatoryEncryption: if you use this option, file gateway only allows connections from SMBv3 clients
         *        that have encryption enabled. This option is highly recommended for environments that handle sensitive
         *        data. This option works with SMB clients on Microsoft Windows 8, Windows Server 2012 or newer.
         * @see SMBSecurityStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SMBSecurityStrategy
         */
        Builder smbSecurityStrategy(String smbSecurityStrategy);

        /**
         * <p>
         * The type of security strategy that was specified for file gateway.
         * </p>
         * <p>
         * ClientSpecified: if you use this option, requests are established based on what is negotiated by the client.
         * This option is recommended when you want to maximize compatibility across different clients in your
         * environment.
         * </p>
         * <p>
         * MandatorySigning: if you use this option, file gateway only allows connections from SMBv2 or SMBv3 clients
         * that have signing enabled. This option works with SMB clients on Microsoft Windows Vista, Windows Server 2008
         * or newer.
         * </p>
         * <p>
         * MandatoryEncryption: if you use this option, file gateway only allows connections from SMBv3 clients that
         * have encryption enabled. This option is highly recommended for environments that handle sensitive data. This
         * option works with SMB clients on Microsoft Windows 8, Windows Server 2012 or newer.
         * </p>
         * 
         * @param smbSecurityStrategy
         *        The type of security strategy that was specified for file gateway.</p>
         *        <p>
         *        ClientSpecified: if you use this option, requests are established based on what is negotiated by the
         *        client. This option is recommended when you want to maximize compatibility across different clients in
         *        your environment.
         *        </p>
         *        <p>
         *        MandatorySigning: if you use this option, file gateway only allows connections from SMBv2 or SMBv3
         *        clients that have signing enabled. This option works with SMB clients on Microsoft Windows Vista,
         *        Windows Server 2008 or newer.
         *        </p>
         *        <p>
         *        MandatoryEncryption: if you use this option, file gateway only allows connections from SMBv3 clients
         *        that have encryption enabled. This option is highly recommended for environments that handle sensitive
         *        data. This option works with SMB clients on Microsoft Windows 8, Windows Server 2012 or newer.
         * @see SMBSecurityStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SMBSecurityStrategy
         */
        Builder smbSecurityStrategy(SMBSecurityStrategy smbSecurityStrategy);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String gatewayARN;

        private String domainName;

        private String activeDirectoryStatus;

        private Boolean smbGuestPasswordSet;

        private String smbSecurityStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSmbSettingsResponse model) {
            super(model);
            gatewayARN(model.gatewayARN);
            domainName(model.domainName);
            activeDirectoryStatus(model.activeDirectoryStatus);
            smbGuestPasswordSet(model.smbGuestPasswordSet);
            smbSecurityStrategy(model.smbSecurityStrategy);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getActiveDirectoryStatus() {
            return activeDirectoryStatus;
        }

        @Override
        public final Builder activeDirectoryStatus(String activeDirectoryStatus) {
            this.activeDirectoryStatus = activeDirectoryStatus;
            return this;
        }

        @Override
        public final Builder activeDirectoryStatus(ActiveDirectoryStatus activeDirectoryStatus) {
            this.activeDirectoryStatus(activeDirectoryStatus == null ? null : activeDirectoryStatus.toString());
            return this;
        }

        public final void setActiveDirectoryStatus(String activeDirectoryStatus) {
            this.activeDirectoryStatus = activeDirectoryStatus;
        }

        public final Boolean getSmbGuestPasswordSet() {
            return smbGuestPasswordSet;
        }

        @Override
        public final Builder smbGuestPasswordSet(Boolean smbGuestPasswordSet) {
            this.smbGuestPasswordSet = smbGuestPasswordSet;
            return this;
        }

        public final void setSmbGuestPasswordSet(Boolean smbGuestPasswordSet) {
            this.smbGuestPasswordSet = smbGuestPasswordSet;
        }

        public final String getSmbSecurityStrategy() {
            return smbSecurityStrategy;
        }

        @Override
        public final Builder smbSecurityStrategy(String smbSecurityStrategy) {
            this.smbSecurityStrategy = smbSecurityStrategy;
            return this;
        }

        @Override
        public final Builder smbSecurityStrategy(SMBSecurityStrategy smbSecurityStrategy) {
            this.smbSecurityStrategy(smbSecurityStrategy == null ? null : smbSecurityStrategy.toString());
            return this;
        }

        public final void setSmbSecurityStrategy(String smbSecurityStrategy) {
            this.smbSecurityStrategy = smbSecurityStrategy;
        }

        @Override
        public DescribeSmbSettingsResponse build() {
            return new DescribeSmbSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
