/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON object containing the Amazon Resource Name (ARN) of the iSCSI volume target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeChapCredentialsRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<DescribeChapCredentialsRequest.Builder, DescribeChapCredentialsRequest> {
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeChapCredentialsRequest::targetARN)).setter(setter(Builder::targetARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ARN_FIELD));

    private final String targetARN;

    private DescribeChapCredentialsRequest(BuilderImpl builder) {
        super(builder);
        this.targetARN = builder.targetARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to
     * return to retrieve the TargetARN for specified VolumeARN.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a>
     *         operation to return to retrieve the TargetARN for specified VolumeARN.
     */
    public String targetARN() {
        return targetARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(targetARN());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeChapCredentialsRequest)) {
            return false;
        }
        DescribeChapCredentialsRequest other = (DescribeChapCredentialsRequest) obj;
        return Objects.equals(targetARN(), other.targetARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeChapCredentialsRequest").add("TargetARN", targetARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetARN":
            return Optional.ofNullable(clazz.cast(targetARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeChapCredentialsRequest, T> g) {
        return obj -> g.apply((DescribeChapCredentialsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeChapCredentialsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a>
         * operation to return to retrieve the TargetARN for specified VolumeARN.
         * </p>
         * 
         * @param targetARN
         *        The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a>
         *        operation to return to retrieve the TargetARN for specified VolumeARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetARN(String targetARN);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String targetARN;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeChapCredentialsRequest model) {
            super(model);
            targetARN(model.targetARN);
        }

        public final String getTargetARN() {
            return targetARN;
        }

        @Override
        public final Builder targetARN(String targetARN) {
            this.targetARN = targetARN;
            return this;
        }

        public final void setTargetARN(String targetARN) {
            this.targetARN = targetARN;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeChapCredentialsRequest build() {
            return new DescribeChapCredentialsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
