/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSnapshotFromVolumeRecoveryPointResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<CreateSnapshotFromVolumeRecoveryPointResponse.Builder, CreateSnapshotFromVolumeRecoveryPointResponse> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSnapshotFromVolumeRecoveryPointResponse::snapshotId)).setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()).build();

    private static final SdkField<String> VOLUME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSnapshotFromVolumeRecoveryPointResponse::volumeARN)).setter(setter(Builder::volumeARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeARN").build()).build();

    private static final SdkField<String> VOLUME_RECOVERY_POINT_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSnapshotFromVolumeRecoveryPointResponse::volumeRecoveryPointTime))
            .setter(setter(Builder::volumeRecoveryPointTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeRecoveryPointTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD,
            VOLUME_ARN_FIELD, VOLUME_RECOVERY_POINT_TIME_FIELD));

    private final String snapshotId;

    private final String volumeARN;

    private final String volumeRecoveryPointTime;

    private CreateSnapshotFromVolumeRecoveryPointResponse(BuilderImpl builder) {
        super(builder);
        this.snapshotId = builder.snapshotId;
        this.volumeARN = builder.volumeARN;
        this.volumeRecoveryPointTime = builder.volumeRecoveryPointTime;
    }

    /**
     * <p>
     * The ID of the snapshot.
     * </p>
     * 
     * @return The ID of the snapshot.
     */
    public String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a> operation to
     * return to retrieve the TargetARN for specified VolumeARN.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a>
     *         operation to return to retrieve the TargetARN for specified VolumeARN.
     */
    public String volumeARN() {
        return volumeARN;
    }

    /**
     * <p>
     * The time the volume was created from the recovery point.
     * </p>
     * 
     * @return The time the volume was created from the recovery point.
     */
    public String volumeRecoveryPointTime() {
        return volumeRecoveryPointTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeARN());
        hashCode = 31 * hashCode + Objects.hashCode(volumeRecoveryPointTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotFromVolumeRecoveryPointResponse)) {
            return false;
        }
        CreateSnapshotFromVolumeRecoveryPointResponse other = (CreateSnapshotFromVolumeRecoveryPointResponse) obj;
        return Objects.equals(snapshotId(), other.snapshotId()) && Objects.equals(volumeARN(), other.volumeARN())
                && Objects.equals(volumeRecoveryPointTime(), other.volumeRecoveryPointTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateSnapshotFromVolumeRecoveryPointResponse").add("SnapshotId", snapshotId())
                .add("VolumeARN", volumeARN()).add("VolumeRecoveryPointTime", volumeRecoveryPointTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "VolumeARN":
            return Optional.ofNullable(clazz.cast(volumeARN()));
        case "VolumeRecoveryPointTime":
            return Optional.ofNullable(clazz.cast(volumeRecoveryPointTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSnapshotFromVolumeRecoveryPointResponse, T> g) {
        return obj -> g.apply((CreateSnapshotFromVolumeRecoveryPointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSnapshotFromVolumeRecoveryPointResponse> {
        /**
         * <p>
         * The ID of the snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a>
         * operation to return to retrieve the TargetARN for specified VolumeARN.
         * </p>
         * 
         * @param volumeARN
         *        The Amazon Resource Name (ARN) of the iSCSI volume target. Use the <a>DescribeStorediSCSIVolumes</a>
         *        operation to return to retrieve the TargetARN for specified VolumeARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeARN(String volumeARN);

        /**
         * <p>
         * The time the volume was created from the recovery point.
         * </p>
         * 
         * @param volumeRecoveryPointTime
         *        The time the volume was created from the recovery point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeRecoveryPointTime(String volumeRecoveryPointTime);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String snapshotId;

        private String volumeARN;

        private String volumeRecoveryPointTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSnapshotFromVolumeRecoveryPointResponse model) {
            super(model);
            snapshotId(model.snapshotId);
            volumeARN(model.volumeARN);
            volumeRecoveryPointTime(model.volumeRecoveryPointTime);
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final String getVolumeARN() {
            return volumeARN;
        }

        @Override
        public final Builder volumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
            return this;
        }

        public final void setVolumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
        }

        public final String getVolumeRecoveryPointTime() {
            return volumeRecoveryPointTime;
        }

        @Override
        public final Builder volumeRecoveryPointTime(String volumeRecoveryPointTime) {
            this.volumeRecoveryPointTime = volumeRecoveryPointTime;
            return this;
        }

        public final void setVolumeRecoveryPointTime(String volumeRecoveryPointTime) {
            this.volumeRecoveryPointTime = volumeRecoveryPointTime;
        }

        @Override
        public CreateSnapshotFromVolumeRecoveryPointResponse build() {
            return new CreateSnapshotFromVolumeRecoveryPointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
